/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.util.CompareUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheSet<K> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private CacheSetity<K>[] table;
    private CacheSetity<K> header;
    private int count;
    private int threshold;
    private float loadFactor;
    private long defaultKeepTime = 0L;
    private int max;

    public CacheSet() {
        this(101, 0.75f);
    }

    public CacheSet(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new CacheSetity[initCapacity];
        this.header = new CacheSetity<Object>(null, 0L, null);
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public synchronized Enumeration<K> keys() {
        return new Enumer(1);
    }

    public synchronized Enumeration<CacheSetity<K>> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsKey(K key) {
        return this.getEntry(key) != null;
    }

    public synchronized K get(K key) {
        CacheSetity<K> e = this.getEntry(key);
        return e == null ? null : (K)e.getKey();
    }

    public synchronized K setKeepAlive(K key, long keepAlive) {
        CacheSetity<K> e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.keepAlive(keepAlive);
        return e.getKey();
    }

    public synchronized K setKeepAlive(K key) {
        CacheSetity<K> e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.keepAlive(this.defaultKeepTime);
        return e.getKey();
    }

    private K getValue(CacheSetity<K> e) {
        if (e == null) {
            return null;
        }
        if (e.isExpired()) {
            this.remove(((CacheSetity)e).key);
            return null;
        }
        return (K)((CacheSetity)e).key;
    }

    public synchronized K getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getValue(this.header.link_next);
    }

    public synchronized K getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getValue(this.header.link_prev);
    }

    private CacheSetity<K> getEntry(K key) {
        if (key == null) {
            return null;
        }
        CacheSetity<K>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        CacheSetity<K> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(((CacheSetity)e).key, key)) {
                if (e.isExpired()) {
                    this.remove(e.getKey());
                    return null;
                }
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized int getRemindTime(K key) {
        CacheSetity<K> entry = this.getEntry(key);
        if (entry != null) {
            if (((CacheSetity)entry).timeOfExpiration == 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)(((CacheSetity)entry).timeOfExpiration - System.currentTimeMillis());
        }
        return 0;
    }

    public void clearExpiredItems() {
        try {
            ArrayList<K> delete = new ArrayList<K>();
            Enumeration<CacheSetity<K>> en = this.entries();
            while (en.hasMoreElements()) {
                CacheSetity<K> e = en.nextElement();
                if (!e.isExpired()) continue;
                delete.add(e.getKey());
            }
            for (int i = 0; i < delete.size(); ++i) {
                this.remove(delete.get(i));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private int hash(Object key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        CacheSetity<K>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        CacheSetity[] newMap = new CacheSetity[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            CacheSetity<K> old = oldMap[i];
            while (old != null) {
                CacheSetity<K> e = old;
                old = old.next;
                Object key = ((CacheSetity)e).key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public CacheSet<K> setMaxRow(int max) {
        this.max = max;
        return this;
    }

    public CacheSet<K> setDefaultKeepTime(long time) {
        this.defaultKeepTime = time;
        return this;
    }

    public K put(K key, long keepTime) {
        return this._put(key, keepTime, 4);
    }

    public K putLast(K key, long keepTime) {
        return this._put(key, keepTime, 2);
    }

    public K putFirst(K key, long keepTime) {
        return this._put(key, keepTime, 1);
    }

    public K put(K key) {
        return this._put(key, this.defaultKeepTime, 4);
    }

    public K putLast(K key) {
        return this._put(key, this.defaultKeepTime, 2);
    }

    public K putFirst(K key) {
        return this._put(key, this.defaultKeepTime, 1);
    }

    private synchronized K _put(K key, long keepTime, int m) {
        CacheSetity<K>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        CacheSetity<K> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(((CacheSetity)e).key, key)) {
                Object old = ((CacheSetity)e).key;
                ((CacheSetity)e).key = key;
                e.keepAlive(keepTime);
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return (K)old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        this.removeLast();
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        this.removeFirst();
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        e = new CacheSetity<K>(key, keepTime, tab[index]);
        tab[index] = e;
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return null;
    }

    public synchronized K remove(K key) {
        if (key == null) {
            return null;
        }
        CacheSetity<K>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        CacheSetity<K> e = tab[index];
        CacheSetity<K> prev = null;
        while (e != null) {
            if (CompareUtil.equals(((CacheSetity)e).key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = ((CacheSetity)e).key;
                ((CacheSetity)e).key = null;
                this.unchain(e);
                return (K)oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized K removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return (K)this.remove(this.header.link_next.key);
    }

    public synchronized K removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        return (K)this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        CacheSetity<K>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<K> it = this.keys();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            K key = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(key);
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<CacheSetity<K>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            CacheSetity<K> e = it.nextElement();
            buf.append("\t").append(e.getKey()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(CacheSetity link_prev, CacheSetity link_next, CacheSetity e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(CacheSetity e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public static void main(String[] args) throws Exception {
        CacheSet<Integer> t = new CacheSet().setDefaultKeepTime(1000L).setMaxRow(100);
        for (int i = 0; i < 100; ++i) {
            t.put(i, i);
        }
        Enumeration e = t.keys();
        System.out.println(t.get(0));
        System.out.println(t.get(10));
        System.out.println(t.get(99));
        Thread.sleep(2000L);
        System.out.println("----->" + t.size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration {
        byte type;
        CacheSetity entry;
        CacheSetity lastEnt;

        Enumer(byte type) {
            this.entry = ((CacheSet)CacheSet.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return CacheSet.this.header != this.entry && this.entry != null;
        }

        public V nextElement() {
            if (this.hasMoreElements()) {
                CacheSetity e = this.lastEnt = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return (V)e.key;
                    }
                }
                return (V)e;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheSetity<K> {
        private K key;
        private long timeOfExpiration;
        private long keepTime = 0L;
        CacheSetity<K> next;
        CacheSetity<K> link_next;
        CacheSetity<K> link_prev;

        protected CacheSetity(K key, long keepTime, CacheSetity next) {
            this.key = key;
            this.keepAlive(keepTime);
            this.next = next;
        }

        protected Object clone() {
            return new CacheSetity<K>(this.key, this.keepTime, this.next == null ? null : (CacheSetity)this.next.clone());
        }

        public K getKey() {
            return this.key;
        }

        public boolean isExpired() {
            if (this.timeOfExpiration > 0L) {
                return this.timeOfExpiration < System.currentTimeMillis();
            }
            return false;
        }

        public void keepAlive(long keepTime) {
            if (keepTime > 0L) {
                this.keepTime = keepTime;
                this.timeOfExpiration = System.currentTimeMillis() + keepTime;
            } else {
                this.keepTime = 0L;
                this.timeOfExpiration = 0L;
            }
        }

        public void keep() {
            if (this.keepTime > 0L) {
                this.timeOfExpiration = System.currentTimeMillis() + this.keepTime;
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheSetity)) {
                return false;
            }
            CacheSetity e = (CacheSetity)o;
            return CompareUtil.equals(this.key, e.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key.toString();
        }
    }
}

