/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import whatap.util.FileUtil;
import whatap.util.IClose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinSearchFile<R, K>
implements IClose {
    private RandomAccessFile raf;
    private int LENGTH;
    private long COUNT;
    private long START;
    private long END;
    protected long cur = 0L;
    protected long low = 0L;
    protected long high = 0L;

    public BinSearchFile(File file, int len) {
        this(file);
        this.setRecordLength(len);
    }

    public BinSearchFile(File file) {
        try {
            this.raf = new RandomAccessFile(file, "r");
            this.setFileSearchRange(0L, this.raf.length());
        }
        catch (IOException e) {
            this.COUNT = 0L;
        }
    }

    public BinSearchFile(RandomAccessFile raf, long start, long end) {
        this.raf = raf;
        this.START = start;
        this.END = end;
    }

    public BinSearchFile<R, K> setFileSearchRange(long start, long end) {
        this.START = start;
        this.END = end;
        return this;
    }

    public BinSearchFile<R, K> setRecordLength(int len) {
        try {
            this.LENGTH = len;
            this.COUNT = (this.END - this.START) / (long)this.LENGTH;
        }
        catch (Exception e) {
            this.COUNT = 0L;
        }
        return this;
    }

    public R find(K key) {
        if (this.isEmpty()) {
            return null;
        }
        try {
            if (this._find(key)) {
                return this.record(this.START + this.cur * (long)this.LENGTH);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public R findLessEqual(K key) {
        if (this.isEmpty()) {
            return null;
        }
        try {
            if (this._find(key)) {
                return this.record(this.START + this.cur * (long)this.LENGTH);
            }
            this.cur = this.high;
            if (this.high < 0L) {
                return null;
            }
            return this.record(this.START + this.cur * (long)this.LENGTH);
        }
        catch (Exception e) {
            return null;
        }
    }

    public R findGreaterEqual(K key) {
        if (this.isEmpty()) {
            return null;
        }
        try {
            if (this._find(key)) {
                return this.record(this.START + this.cur * (long)this.LENGTH);
            }
            this.cur = this.low;
            if (this.low >= this.COUNT) {
                return null;
            }
            return this.record(this.START + this.cur * (long)this.LENGTH);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean _find(K key) throws Exception {
        this.cur = -1L;
        this.low = 0L;
        this.high = this.COUNT - 1L;
        while (this.high >= this.low) {
            long middle = (this.low + this.high) / 2L;
            long cmp = this.compare(key, this.key(this.START + middle * (long)this.LENGTH));
            if (cmp == 0L) {
                this.cur = middle;
                return true;
            }
            if (cmp > 0L) {
                this.low = middle + 1L;
                continue;
            }
            if (cmp >= 0L) continue;
            this.high = middle - 1L;
        }
        return false;
    }

    private boolean isEmpty() {
        return this.COUNT <= 0L;
    }

    public R readPrev() {
        if (this.cur < 0L || this.cur >= this.COUNT) {
            return null;
        }
        if (--this.cur < 0L) {
            return null;
        }
        try {
            return this.record(this.START + this.cur * (long)this.LENGTH);
        }
        catch (Exception e) {
            this.cur = -1L;
            return null;
        }
    }

    public R readNext() {
        if (this.cur < 0L || this.cur >= this.COUNT) {
            return null;
        }
        if (++this.cur >= this.COUNT) {
            return null;
        }
        try {
            return this.record(this.START + this.cur * (long)this.LENGTH);
        }
        catch (Exception e) {
            this.cur = -1L;
            return null;
        }
    }

    public byte[] read(long pos, int len) throws IOException {
        byte[] buf = new byte[len];
        this.raf.seek(pos);
        this.raf.read(buf);
        return buf;
    }

    protected abstract R record(long var1) throws Exception;

    protected abstract K key(long var1) throws Exception;

    protected abstract int compare(K var1, K var2);

    @Override
    public void close() {
        FileUtil.close(this.raf);
    }
}

