/*
 * Decompiled with CFR 0.152.
 */
package whatap.reqlog.sink;

import java.io.IOException;
import whatap.agent.Logger;
import whatap.agent.trace.HttpLog;
import whatap.agent.trace.TraceContext;
import whatap.lang.conf.ConfObserver;
import whatap.logsink.LineLog;
import whatap.logsink.fw.LogTracer;
import whatap.reqlog.ReqLogConf;
import whatap.util.IPUtil;
import whatap.util.RequestQueue;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class ReqLogSinkThread
extends Thread {
    private static ReqLogSinkThread instance;
    private long last_log = System.currentTimeMillis();
    private long failcount = 0L;
    private long last_write_log = System.currentTimeMillis();
    private long failwrite = 0L;
    private RequestQueue<TraceContext> buffer = new RequestQueue(ReqLogConf.reqlog_queue_size);
    static long lastnull;
    boolean bRun = true;

    public static synchronized ReqLogSinkThread getInstance() {
        if (instance == null) {
            instance = new ReqLogSinkThread();
            instance.setName("ReqLogSinkThread");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public ReqLogSinkThread() {
        ConfObserver.add(ReqLogSinkThread.class.getName(), new Runnable(){

            public void run() {
                ReqLogSinkThread.this.buffer.setCapacity(ReqLogConf.reqlog_queue_size);
            }
        });
    }

    public void add(TraceContext r) {
        boolean ok = this.buffer.put(r);
        if (!ok) {
            ++this.failcount;
            long now = System.currentTimeMillis();
            if (now - this.last_log > ReqLogConf.reqlog_faillog_interval) {
                this.last_log = now;
                Logger.println("reqlog queue full #" + this.failcount);
            }
        }
    }

    public void run() {
        while (this.bRun) {
            long now;
            try {
                TraceContext r = this.buffer.get();
                this.process(r);
            }
            catch (NullPointerException t) {
                now = System.currentTimeMillis();
                if (now - lastnull <= 1000000L) continue;
                Logger.println("reqlog sink fail null =>  " + ThreadUtil.getStackTrace(t));
            }
            catch (Throwable t) {
                ++this.failwrite;
                now = System.currentTimeMillis();
                if (now - this.last_write_log <= ReqLogConf.reqlog_faillog_interval) continue;
                this.last_write_log = now;
                Logger.println("reqlog sink fail #" + this.failwrite + " " + t);
            }
        }
    }

    private void process(TraceContext r) throws IOException {
        if (ReqLogConf.reqlog_error_only_enabled) {
            if (r.error != null) {
                LogTracer.logdirect(this.build(r));
            }
        } else {
            LogTracer.logdirect(this.build(r));
        }
        r.reset();
    }

    private LineLog build(TraceContext x) {
        StringBuffer fullUrl;
        char seperator = ReqLogConf.reqlog_seperator;
        LineLog linelog = new LineLog();
        linelog.time = x.endTime;
        linelog.category = "#DirectReqLog";
        linelog.fields.put("stime", x.endTime - (long)x.elapsed);
        if (ReqLogConf.reqlog_x_etime) {
            linelog.fields.put("etime", x.endTime);
        }
        if (ReqLogConf.reqlog_x_elapsed) {
            linelog.fields.put("elapsed.n", x.elapsed);
        }
        if (ReqLogConf.reqlog_x_url) {
            linelog.fields.put("url", x.service_name);
        }
        if (ReqLogConf.reqlog_x_full_url && (fullUrl = x.http_url) != null) {
            if (x.http_query != null) {
                fullUrl.append("?").append(x.http_query);
            }
            linelog.fields.put("fullUrl", fullUrl.toString());
        }
        if (ReqLogConf.reqlog_x_httphost && x.http_host != null) {
            linelog.fields.put("httphost", x.http_host);
        }
        if (ReqLogConf.reqlog_x_method) {
            linelog.fields.put("method", x.http_method);
        }
        if (ReqLogConf.reqlog_x_ip && x.remoteIp != 0) {
            linelog.fields.put("ip", IPUtil.toString(x.remoteIp));
        }
        if (ReqLogConf.reqlog_x_status) {
            linelog.fields.put("status", x.status);
        }
        if (ReqLogConf.reqlog_x_wcid && x.wclientId != 0L) {
            linelog.fields.put("wclient", x.wclientId);
        }
        if (ReqLogConf.reqlog_x_login && x.login != null) {
            linelog.fields.put("login", x.login);
        }
        if (ReqLogConf.reqlog_x_error && x.error != null) {
            linelog.fields.put("errCls", x.error.className);
            if (ReqLogConf.reqlog_x_errormsg) {
                linelog.fields.put("errMsg", StringUtil.limiting(x.error.message, ReqLogConf.reqlog_value_limit));
            }
        }
        if (ReqLogConf.reqlog_x_useragent) {
            linelog.fields.put("userAgent", StringUtil.limiting(x.userAgentString, ReqLogConf.reqlog_value_limit));
        }
        if (ReqLogConf.reqlog_x_txid) {
            linelog.fields.put("txid", x.txid);
        }
        if (x.custid != null) {
            if (ReqLogConf.reqlog_x_custid) {
                linelog.fields.put("custid", x.custid);
            } else if (ReqLogConf.reqlog_x_gtid) {
                linelog.fields.put("gtid", x.custid);
            }
        }
        if (ReqLogConf.reqlog_x_mtid && x.mtid != 0L) {
            linelog.fields.put("mtid", x.mtid);
            if (ReqLogConf.reqlog_x_mdepth) {
                linelog.fields.put("mdepth.n", x.mdepth);
            }
        }
        if (ReqLogConf.reqlog_x_dbc && x.dbc_time > 0) {
            linelog.fields.put("dbcTime.n", x.dbc_time);
        }
        if (ReqLogConf.reqlog_x_sql && x.sql_count > 0) {
            linelog.fields.put("sqlCnt.n", x.sql_count);
            linelog.fields.put("sqlTime.n", x.sql_time);
        }
        if (ReqLogConf.reqlog_x_httpc && x.httpc_count > 0) {
            linelog.fields.put("httpCallCnt.n", x.httpc_count);
            linelog.fields.put("httpCallTime.n", x.httpc_time);
        }
        if (ReqLogConf.reqlog_x_rs && x.rs_count > 0) {
            linelog.fields.put("rsCnt.n", x.rs_count);
            linelog.fields.put("rsTime.n", x.rs_time);
        }
        if (x.reqlog != null) {
            int i;
            int len;
            HttpLog reqlog = x.reqlog;
            if (reqlog.req_header_key != null) {
                len = reqlog.req_header_key.length;
                for (i = 0; i < len; ++i) {
                    linelog.fields.put(reqlog.req_header_key[i], reqlog.req_header_value[i]);
                }
            }
            if (reqlog.req_parameter_key != null && reqlog.req_parameter_value != null) {
                len = reqlog.req_parameter_key.length;
                for (i = 0; i < len; ++i) {
                    linelog.fields.put(reqlog.req_parameter_key[i], StringUtil.limiting(reqlog.req_parameter_value[i], ReqLogConf.reqlog_value_limit));
                }
            }
            if (reqlog.req_cookie_key != null && reqlog.req_cookie_value != null) {
                len = reqlog.req_cookie_key.length;
                for (i = 0; i < len; ++i) {
                    linelog.fields.put(reqlog.req_cookie_key[i], reqlog.req_cookie_value[i]);
                }
            }
            if (reqlog.resp_header_key != null && reqlog.resp_header_value != null) {
                len = reqlog.resp_header_key.length;
                for (i = 0; i < len; ++i) {
                    linelog.fields.put(reqlog.resp_header_key[i], reqlog.resp_header_value[i]);
                }
            }
        }
        return linelog;
    }

    static {
        lastnull = 0L;
    }
}

