/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.sys.mac.tcp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.perfx.sys.PerfXSystem;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.StringEnumer;
import whatap.util.StringIntMap;

public class TcpStateOSXCounter {
    public static void tcp4() {
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "serverx_tcp4_count";
        p.tags.put("!rectype", 1);
        TcpStateOSXCounter.calc("tcp4", p);
        PerfXSystem.setTagAgentInfo(p);
        DataPackSender.send(p, false);
    }

    public static void tcp6() {
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "serverx_tcp6_count";
        p.tags.put("!rectype", 1);
        TcpStateOSXCounter.calc("tcp6", p);
        PerfXSystem.setTagAgentInfo(p);
        DataPackSender.send(p, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void calc(String protocol, TagCountPack p) {
        Process proc = null;
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            String cmd = "netstat -nat";
            proc = Runtime.getRuntime().exec(cmd);
            BufferedReader bin = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            StringIntMap stateCounts = new StringIntMap();
            String line = bin.readLine();
            while (line != null) {
                String[] parts;
                if (line.startsWith(protocol) && (parts = line.trim().split("\\s+")).length > 5) {
                    String state = parts[5];
                    stateCounts.add(state, 1);
                }
                line = bin.readLine();
            }
            p.putTag("protocol", protocol);
            StringEnumer en = stateCounts.keys();
            while (en.hasMoreElements()) {
                String key = en.nextString();
                int count = stateCounts.get(key);
                p.fields.put(key, count);
            }
        }
        catch (Throwable t) {
            Logger.println("ShellPerf", 10, t.toString());
        }
        finally {
            FileUtil.close(in);
            FileUtil.close(out);
            FileUtil.close(err);
            try {
                if (proc != null) {
                    proc.destroy();
                }
            }
            catch (Throwable cmd) {}
        }
    }
}

