/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink;

import java.util.List;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.conf.ConfPIIMask;
import whatap.agent.data.DataPackSender;
import whatap.agent.pii.PiiMask;
import whatap.agent.plugin.PluginLogSink;
import whatap.lang.pack.LogSinkPack;
import whatap.logsink.LineLog;
import whatap.logsink.LineLogUtil;
import whatap.logsink.zip.ZipSendProxyThread;
import whatap.util.AnsiPrint;
import whatap.util.DateUtil;
import whatap.util.StringUtil;

public class SenderUtil {
    static SecurityMaster secu = SecurityMaster.getInstance();
    static Configure conf = Configure.getInstance();

    public static void send(LineLog alog) {
        LogSinkPack p = new LogSinkPack();
        p.time = alog.time;
        if (p.time <= 0L) {
            p.time = DateUtil.currentTime();
        }
        p.category = alog.category;
        if (SenderUtil.secu.ONAME != null) {
            p.tags.put("oname", SenderUtil.secu.ONAME);
        }
        if (SenderUtil.conf.OKIND != 0) {
            p.tags.put("okindName", SenderUtil.conf.OKIND_NAME);
        }
        if (SenderUtil.conf.ONODE != 0) {
            p.tags.put("onodeName", SenderUtil.conf.ONODE_NAME);
        }
        if (alog.tags != null) {
            p.tags.putAll(alog.tags);
        }
        if (alog.fields != null) {
            if (p.fields == null) {
                p.fields = alog.fields;
            } else {
                p.fields.putAll(alog.fields);
            }
        }
        p.content = alog.content;
        if (ConfLogSink._has_logsink_tags_) {
            List<String[]> tags = ConfLogSink.logsink_tags;
            for (int i = 0; i < tags.size(); ++i) {
                String[] tag = tags.get(i);
                p.tags.put(tag[0], tag[1]);
            }
        }
        if (ConfPIIMask.pii_mask_logsink_enabled) {
            PiiMask.parseLogSink(p);
        }
        PluginLogSink.process(p);
        if (p.dropped) {
            return;
        }
        if (alog.truncated) {
            p.tags.put("@truncated", true);
            p.tags.put("@origin_length", alog.orgContentLength);
            LineLogUtil.log(alog);
        }
        if (ConfLogSink.logsink_zip_enabled) {
            ZipSendProxyThread.getInstance().add(p);
        } else {
            DataPackSender.sendLogSink(p, false);
        }
        if (ConfLogSink.debug_logsink_enabled) {
            StringBuffer log = new StringBuffer();
            log.append("[");
            log.append(AnsiPrint.green(alog.category));
            log.append("|" + AnsiPrint.yellow(p.line));
            log.append("] ");
            log.append(AnsiPrint.yellow(p.tags.toString())).append(" ");
            if (ConfLogSink.debug_logsink_limit_content_length > 2 && alog.content.length() > ConfLogSink.debug_logsink_limit_content_length) {
                log.append(alog.content.substring(0, ConfLogSink.debug_logsink_limit_content_length - 2));
            } else {
                log.append(alog.content);
            }
            if (alog.content != null && !alog.content.endsWith("\n")) {
                log.append("\n");
            }
            Logger.write(log.toString());
        }
    }

    public static void send(LogSinkPack p) {
        if (ConfPIIMask.pii_mask_logsink_enabled) {
            PiiMask.parseLogSink(p);
        }
        PluginLogSink.process(p);
        if (p.dropped) {
            return;
        }
        if (ConfLogSink.logsink_zip_enabled) {
            ZipSendProxyThread.getInstance().add(p);
        } else {
            DataPackSender.sendLogSink(p, false);
        }
        if (ConfLogSink.debug_logsink_enabled) {
            StringBuffer log = new StringBuffer();
            log.append("[");
            log.append(AnsiPrint.green(p.category));
            log.append("|" + AnsiPrint.yellow(p.line));
            log.append("] ");
            log.append(AnsiPrint.yellow(p.tags.toString())).append(" ");
            if (StringUtil.isNotEmpty(p.content)) {
                if (ConfLogSink.debug_logsink_limit_content_length > 2 && p.content.length() > ConfLogSink.debug_logsink_limit_content_length) {
                    log.append(p.content.substring(0, ConfLogSink.debug_logsink_limit_content_length - 2));
                } else {
                    log.append(p.content);
                }
                if (!p.content.endsWith("\n")) {
                    log.append("\n");
                }
            } else {
                log.append("\n");
            }
            Logger.write(log.toString());
        }
    }
}

