/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.text.DecimalFormat;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.Value;
import whatap.util.CompareUtil;

public class MetricValue
implements Value {
    public int count;
    public double sum;
    public float min;
    public float max;
    public float last;

    public byte getValueType() {
        return 82;
    }

    public void write(DataOutputX out) {
        if (this.count == 0) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeDecimal(this.count);
            out.writeDouble(this.sum);
            out.writeFloat(this.min);
            out.writeFloat(this.max);
            out.writeFloat(this.last);
        }
    }

    public Value read(DataInputX in) {
        byte mode = in.readByte();
        switch (mode) {
            case 0: {
                return this;
            }
            case 1: {
                this.count = (int)in.readDecimal();
                this.sum = in.readDouble();
                this.min = in.readFloat();
                this.max = in.readFloat();
                this.last = in.readFloat();
            }
        }
        return this;
    }

    public int compareTo(Object o) {
        return CompareUtil.compareTo(this.hashCode(), o.hashCode());
    }

    public String toString() {
        DecimalFormat fmt = new DecimalFormat("#0.0#################");
        StringBuffer sb = new StringBuffer();
        sb.append("[sum=").append(fmt.format(new Double(this.sum)));
        sb.append(",count=").append(this.count);
        sb.append(",min=").append(fmt.format(new Float(this.min)));
        sb.append(",max=").append(fmt.format(new Float(this.max)));
        sb.append(",last=").append(fmt.format(new Float(this.last)));
        sb.append("]");
        return sb.toString();
    }

    public Object toJavaObject() {
        return this;
    }

    public void addcount() {
        ++this.count;
    }

    public MetricValue add(Number value) {
        if (value == null) {
            return this;
        }
        float fval = value.floatValue();
        if (this.count == 0) {
            this.count = 1;
            this.sum = fval;
            this.max = fval;
            this.min = fval;
        } else {
            ++this.count;
            this.sum += (double)fval;
            this.max = Math.max(this.max, fval);
            this.min = Math.min(this.min, fval);
        }
        this.last = value.floatValue();
        return this;
    }

    public double sum() {
        return this.sum;
    }

    public float min() {
        return this.min;
    }

    public float max() {
        return this.max;
    }

    public float last() {
        return this.last;
    }

    public float avg() {
        return (float)(this.count == 0 ? 0.0 : this.sum / (double)this.count);
    }

    public int getCount() {
        return this.count;
    }

    public Value copy() {
        MetricValue o = new MetricValue();
        o.count = this.count;
        o.max = this.max;
        o.min = this.min;
        o.sum = this.sum;
        o.last = this.last;
        return o;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }
}

