/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.DoubleValue;
import whatap.lang.value.FloatValue;
import whatap.lang.value.ListValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;
import whatap.org.json.JSONObject;
import whatap.util.CompareUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapValue
implements Value {
    protected StringKeyLinkedMap<Value> table = new StringKeyLinkedMap();

    public MapValue() {
    }

    public MapValue(MapValue m) {
        this.table.putAll(m.table);
    }

    public int size() {
        return this.table.size();
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }

    public String[] keyArray() {
        String[] _keys = new String[this.size()];
        StringEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextString();
        }
        return _keys;
    }

    public StringEnumer keys() {
        return this.table.keys();
    }

    public Value get(String key) {
        return this.table.get(key);
    }

    public boolean getBoolean(String key) {
        Value v = this.get(key);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return false;
    }

    public int getInt(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    public long getLong(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return 0L;
    }

    public float getFloat(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    public String getText(String key) {
        Value v = this.get(key);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        return null;
    }

    public Value put(String key, Value value) {
        return this.table.put(key, value);
    }

    public Value put(String key, String value) {
        return this.put(key, new TextValue(value));
    }

    public Value put(String key, long value) {
        return this.put(key, new DecimalValue(value));
    }

    public Value put(String key, int value) {
        return this.put(key, new DecimalValue(value));
    }

    public Value put(String key, float value) {
        return this.put(key, new FloatValue(value));
    }

    public Value put(String key, double value) {
        return this.put(key, new DoubleValue(value));
    }

    public Value put(String key, boolean value) {
        return this.put(key, new BooleanValue(value));
    }

    public Value remove(String key) {
        return this.table.remove(key);
    }

    public void clear() {
        this.table.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = this.table.entries();
        buf.append("{");
        while (en.hasMoreElements()) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> e = en.nextElement();
            buf.append(e.getKey() + "=" + e.getValue());
        }
        buf.append("}");
        return buf.toString();
    }

    public String toJSONString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = this.table.entries();
        buf.append("{");
        while (en.hasMoreElements()) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> e = en.nextElement();
            buf.append('\"').append(e.getKey()).append("\" : ");
            Value value = e.getValue();
            if (value.getValueType() == 50) {
                buf.append(JSONObject.quote(value.toString()));
                continue;
            }
            if (value.getValueType() == 80) {
                buf.append(((MapValue)value).toJSONString());
                continue;
            }
            if (value.getValueType() == 70) {
                buf.append(((ListValue)value).toJSONString());
                continue;
            }
            buf.append(value.toString());
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public byte getValueType() {
        return 80;
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        int sz = this.table.size();
        dout.writeDecimal(sz);
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = this.table.entries();
        for (int i = 0; i < sz; ++i) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> e = en.nextElement();
            dout.writeText(e.getKey());
            dout.writeValue(e.getValue());
        }
    }

    @Override
    public Value read(DataInputX din) throws IOException {
        int count = (int)din.readDecimal();
        for (int t = 0; t < count; ++t) {
            String key = din.readText();
            Value value = din.readValue();
            this.put(key, value);
        }
        return this;
    }

    public ListValue newList(String name) {
        ListValue list = new ListValue();
        this.put(name, list);
        return list;
    }

    public ListValue getList(String key) {
        return (ListValue)this.table.get(key);
    }

    public ListValue getListNotNull(String key) {
        ListValue lv = (ListValue)this.table.get(key);
        return lv == null ? new ListValue() : lv;
    }

    public synchronized ListValue internList(String key) {
        ListValue lv = (ListValue)this.table.get(key);
        if (lv == null) {
            lv = new ListValue();
            this.table.put(key, lv);
        }
        return lv;
    }

    @Override
    public Object toJavaObject() {
        return this.table;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapValue other = (MapValue)obj;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = this.table.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            Value otherValue = other.get(ent.getKey());
            if (ent.getValue().equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public void putAll(Map<String, Value> m) {
        for (Map.Entry<String, Value> e : m.entrySet()) {
            this.table.put(e.getKey(), e.getValue());
        }
    }

    public void putAll(MapValue m) {
        StringEnumer strEnumer = m.keys();
        while (strEnumer.hasMoreElements()) {
            String key = strEnumer.nextString();
            this.table.put(key, m.get(key));
        }
    }

    public int getInt(String key, int i) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return i;
    }

    public long getLong(String key, long def) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return def;
    }

    public float getFloat(String key, float def) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return def;
    }

    public double getDouble(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).doubleValue();
        }
        return 0.0;
    }

    public String getText(String key, String def) {
        Value v = this.get(key);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        Value v = this.get(key);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return def;
    }

    public static boolean isEmpty(MapValue r) {
        return r == null || r.size() == 0;
    }

    public void putStringMapAll(Map<String, String> out) {
        if (out == null) {
            return;
        }
        for (Map.Entry<String, String> e : out.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> entries() {
        return this.table.entries();
    }

    public MapValue getMap(String key) {
        return (MapValue)this.table.get(key);
    }

    @Override
    public int compareTo(Object o) {
        return CompareUtil.compareTo(this.hashCode(), o.hashCode());
    }

    @Override
    public Value copy() {
        return new MapValue(this);
    }
}

