/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.io.IOException;
import java.util.Arrays;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.ArrayValue;
import whatap.lang.value.DoubleValue;
import whatap.lang.value.Value;
import whatap.util.CompareUtil;

public class DoubleArray
implements Value,
Comparable,
ArrayValue {
    public double[] value;
    private int _hash;

    public DoubleArray() {
    }

    public DoubleArray(double[] value) {
        this.value = value;
    }

    public int length() {
        return this.value == null ? 0 : this.value.length;
    }

    public ArrayValue subArray(int start, int end) {
        int len = end - start;
        if (len == 0) {
            return new DoubleArray(new double[0]);
        }
        if (len == this.value.length) {
            return this;
        }
        double[] out = new double[len];
        System.arraycopy(this.value, start, out, 0, len);
        return new DoubleArray(out);
    }

    public Value get(int i) {
        return new DoubleValue(this.value[i]);
    }

    public boolean isNumber() {
        return true;
    }

    public int compareTo(Object o) {
        if (o instanceof DoubleArray) {
            return CompareUtil.compareTo(this.value, ((DoubleArray)o).value);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof DoubleArray) {
            return Arrays.equals(this.value, ((DoubleArray)o).value);
        }
        return false;
    }

    public int hashCode() {
        if (this._hash == 0) {
            this._hash = Arrays.hashCode(this.value);
        }
        return this._hash;
    }

    public byte getValueType() {
        return 75;
    }

    public void write(DataOutputX out) throws IOException {
        out.writeArray(this.value);
    }

    public Value read(DataInputX in) throws IOException {
        this.value = in.readArray(new double[0]);
        return this;
    }

    public String toString() {
        return Arrays.toString(this.value);
    }

    public Object toJavaObject() {
        return this.value;
    }

    public Value copy() {
        return new DoubleArray(this.value);
    }

    public boolean isEmpty() {
        return this.value == null || this.value.length == 0;
    }
}

