/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.NumberValue;
import whatap.lang.value.Value;

public class DecimalValue
extends NumberValue
implements Value,
Comparable {
    public long value;

    public DecimalValue() {
    }

    public DecimalValue(long value) {
        this.value = value;
    }

    public int compareTo(Object o) {
        if (o instanceof DecimalValue) {
            long thisVal = this.value;
            long anotherVal = ((DecimalValue)o).value;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof DecimalValue) {
            return this.value == ((DecimalValue)o).value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public byte getValueType() {
        return 20;
    }

    public void write(DataOutputX out) throws IOException {
        out.writeDecimal(this.value);
    }

    public Value read(DataInputX in) throws IOException {
        this.value = in.readDecimal();
        return this;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public Object toJavaObject() {
        return this.value;
    }

    public Value copy() {
        return new DecimalValue(this.value);
    }

    public boolean isEmpty() {
        return this.value == 0L;
    }
}

