/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.topology;

import java.util.Enumeration;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.topology.LINK;
import whatap.lang.value.MapValue;
import whatap.org.json.JSONArray;
import whatap.org.json.JSONObject;
import whatap.util.CastUtil;
import whatap.util.LinkedSet;
import whatap.util.StringEnumer;
import whatap.util.StringSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NODE {
    public MapValue attr = new MapValue();
    public LinkedSet<LINK> listen = new LinkedSet();
    public LinkedSet<LINK> outter = new LinkedSet();

    public String toString() {
        return this.attr + "\nlisten\n" + this.toString(this.listen, "\t") + "\noutter\n" + this.toString(this.outter, "\t");
    }

    private String toString(LinkedSet<LINK> t, String space) {
        StringBuffer buf = new StringBuffer();
        Enumeration<LINK> it = t.elements();
        while (it.hasMoreElements()) {
            buf.append(space).append(it.nextElement()).append("\n");
        }
        return buf.toString();
    }

    public boolean isAttachable(LINK k) {
        Enumeration<LINK> en = this.listen.elements();
        while (en.hasMoreElements()) {
            LINK n = en.nextElement();
            if (n == null || !n.include(k)) continue;
            return true;
        }
        return false;
    }

    public byte[] toBytes() {
        DataOutputX out = new DataOutputX();
        out.writeByte(0);
        out.writeValue(this.attr);
        this.toLinkBytes(this.listen, out);
        this.toLinkBytes(this.outter, out);
        return out.toByteArray();
    }

    public NODE toObject(byte[] b) {
        DataInputX in = new DataInputX(b);
        byte ver = in.readByte();
        this.attr = (MapValue)in.readValue();
        this.listen = this.toLinkObject(in);
        this.outter = this.toLinkObject(in);
        return this;
    }

    private LinkedSet<LINK> toLinkObject(DataInputX in) {
        LinkedSet<LINK> data = new LinkedSet<LINK>();
        int sz = (int)in.readDecimal();
        for (int i = 0; i < sz; ++i) {
            data.put(new LINK().toObject(in));
        }
        return data;
    }

    private void toLinkBytes(LinkedSet<LINK> data, DataOutputX out) {
        out.writeDecimal(data.size());
        if (data.size() == 0) {
            return;
        }
        Enumeration<LINK> en = data.elements();
        while (en.hasMoreElements()) {
            LINK k = en.nextElement();
            k.toBytes(out);
        }
    }

    public void addListen(StringSet localIpSet, String listenAddr) {
        IPO ipo = this.getIPPORT(listenAddr);
        if (ipo == null || ipo.isLocal127()) {
            return;
        }
        if (ipo.ip.equals("*") || ipo.ip.equals("0.0.0.0") || ipo.ip.equals("::")) {
            StringEnumer en = localIpSet.keys();
            while (en.hasMoreElements()) {
                String local_ip = en.nextString();
                LINK k = LINK.create(local_ip, CastUtil.cint(ipo.port));
                if (k == null) continue;
                this.listen.put(k);
            }
        } else {
            LINK k = LINK.create(ipo.ip, CastUtil.cint(ipo.port));
            if (k != null) {
                this.listen.put(k);
            }
        }
    }

    private IPO getIPPORT(String listenAddr) {
        try {
            IPO ipo = new IPO();
            int x = listenAddr.lastIndexOf(58);
            if (x < 0) {
                x = listenAddr.lastIndexOf(".");
            }
            ipo.ip = listenAddr.substring(0, x);
            ipo.port = listenAddr.substring(x + 1);
            return ipo;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addOutter(String local, String remote) {
        IPO localIPO = this.getIPPORT(local);
        if (localIPO == null || localIPO.isIPv6()) {
            return;
        }
        if (this.hasListen(localIPO.ip, localIPO.port)) {
            return;
        }
        IPO remortIPO = this.getIPPORT(remote);
        if (remortIPO == null || remortIPO.isIPv6() || remortIPO.isLocal127()) {
            return;
        }
        LINK k = LINK.create(remortIPO.ip, CastUtil.cint(remortIPO.port));
        if (k != null) {
            this.outter.put(k);
        }
    }

    private boolean hasListen(String ip, String port) {
        LINK k = LINK.create(ip, CastUtil.cint(port));
        if (k == null) {
            return false;
        }
        return this.listen.contains(k);
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put("attr", new JSONObject(this.attr.toJSONString()));
        o.put("listen", this.toJSON(this.listen));
        o.put("outter", this.toJSON(this.outter));
        return o;
    }

    private JSONArray toJSON(LinkedSet<LINK> data) {
        JSONArray out = new JSONArray();
        Enumeration<LINK> en = data.elements();
        while (en.hasMoreElements()) {
            LINK k = en.nextElement();
            out.put(k.toString());
        }
        return out;
    }

    static class IPO {
        String ip;
        String port;

        IPO() {
        }

        public boolean isIPv6() {
            return this.ip != null && this.ip.indexOf(58) >= 0;
        }

        public boolean isLocal127() {
            return "127.0.0.1".equals(this.ip);
        }
    }
}

