/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.step;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.step.ActiveStackStep;
import whatap.lang.step.DBCStep;
import whatap.lang.step.DBCStepX;
import whatap.lang.step.HttpcStepX;
import whatap.lang.step.MessageStep;
import whatap.lang.step.MessageStepX;
import whatap.lang.step.MethodStepX;
import whatap.lang.step.RemoteStep;
import whatap.lang.step.ResultSetStep;
import whatap.lang.step.SecureMsgStep;
import whatap.lang.step.SocketStep;
import whatap.lang.step.SqlStepX;
import whatap.lang.step.Step;

public class StepEnum {
    public static final byte METHOD = 1;
    public static final byte SQL = 2;
    public static final byte RESULTSET = 3;
    public static final byte HTTPCALL = 4;
    public static final byte SOCKET = 5;
    public static final byte ACTIVE_STACK = 6;
    public static final byte MESSAGE = 7;
    public static final byte DBC = 8;
    public static final byte SQL_2 = 9;
    public static final byte METHOD_2 = 11;
    public static final byte METHOD_3 = 12;
    public static final byte SQL_3 = 13;
    public static final byte HTTPCALL_3 = 14;
    public static final byte SECURE_MESSAGE = 15;
    public static final byte CHILD_THREAD = 16;
    public static final byte METHOD_X = 17;
    public static final byte SQL_X = 18;
    public static final byte HTTPCALL_X = 19;
    public static final byte REMOTE = 20;
    public static final byte DBC_X = 21;
    public static final byte MESSAGE_X = 22;

    public static Step create(byte type) throws IOException {
        switch (type) {
            case 17: {
                return new MethodStepX();
            }
            case 18: {
                return new SqlStepX();
            }
            case 3: {
                return new ResultSetStep();
            }
            case 5: {
                return new SocketStep();
            }
            case 19: {
                return new HttpcStepX();
            }
            case 6: {
                return new ActiveStackStep();
            }
            case 7: {
                return new MessageStep();
            }
            case 15: {
                return new SecureMsgStep();
            }
            case 8: {
                return new DBCStep();
            }
            case 20: {
                return new RemoteStep();
            }
            case 21: {
                return new DBCStepX();
            }
            case 22: {
                return new MessageStepX();
            }
        }
        throw new RuntimeException("unknown step type=" + type);
    }

    public static void main(String[] args) {
        SqlStepX x = new SqlStepX();
        DataOutputX o = new DataOutputX();
        o.writeStep(x);
        byte[] b = o.toByteArray();
        DataInputX i = new DataInputX(b);
        x = (SqlStepX)i.readStep();
        System.out.println(x);
    }
}

