/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.slog;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import whatap.lang.slog.Fmt;
import whatap.lang.slog.SMap;
import whatap.lang.slog.Type;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.util.AnsiPrint;
import whatap.util.CastUtil;
import whatap.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLog {
    private static final String INDICATOR = "[+]";
    private StringBuilder buffer;
    private static SimpleDateFormat timeformat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public SLog() {
        this(80);
    }

    public SLog(int len) {
        this.buffer = new StringBuilder(len);
        this.buffer.append(INDICATOR);
    }

    public SLog append(String key, String value) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        if (value == null) {
            this.addNull();
        } else {
            this.addText(value);
        }
        return this;
    }

    private void addNull() {
        this.buffer.append('\"').append('\"');
    }

    private void addText(String value) {
        boolean hasSpace = false;
        char[] str = value.toCharArray();
        block4: for (int i = 0; i < str.length; ++i) {
            switch (str[i]) {
                case '\"': {
                    str[i] = 39;
                    continue block4;
                }
                case ' ': {
                    hasSpace = true;
                }
            }
        }
        if (hasSpace) {
            this.buffer.append('\"');
            this.buffer.append(str);
            this.buffer.append('\"');
        } else {
            this.buffer.append(str);
        }
    }

    public SLog append(String key, Object value) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        if (value == null) {
            this.addNull();
        } else if (value instanceof String) {
            this.addText((String)value);
        } else if (value instanceof Number) {
            if (value instanceof Float || value instanceof Double) {
                this.buffer.append(new DecimalFormat("#0.0#######").format(value));
            } else {
                this.buffer.append(value);
            }
        } else {
            this.addText(value.toString());
        }
        return this;
    }

    public SLog append(String key, long value) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(value);
        return this;
    }

    public SLog yellow(String key, long value) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(AnsiPrint.yellow(value));
        return this;
    }

    public SLog append(String key, float value) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(value);
        return this;
    }

    public SLog yellow(String key, float value) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(AnsiPrint.yellow(Float.valueOf(value)));
        return this;
    }

    public SLog append(String key, double value) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(new DecimalFormat("#0.0#######").format(value));
        return this;
    }

    public SLog yellow(String key, double value) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(AnsiPrint.yellow(new DecimalFormat("#0.0#######").format(value)));
        return this;
    }

    public SLog append(String key, float value, String format) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(new DecimalFormat(format).format(value));
        return this;
    }

    public SLog append(String key, double value, String format) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(new DecimalFormat(format).format(value));
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public SLog time(String key, Date time) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(timeformat.format(time));
        return this;
    }

    public SLog t(String key, Date date) {
        return this.time(key, date);
    }

    public SLog t(String key, long date) {
        return this.time(key, new Date(date));
    }

    public SLog date(String key, Date date) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append(dateformat.format(date));
        return this;
    }

    public SLog d(String key, Date date) {
        return this.date(key, date);
    }

    public SLog d(String key, long date) {
        return this.date(key, new Date(date));
    }

    public SLog timestamp(String key, Date date) {
        this.buffer.append(' ');
        this.buffer.append(key).append('=');
        this.buffer.append('\"').append(timestampFormat.format(date)).append('\"');
        return this;
    }

    public SLog ts(String key, Date date) {
        return this.timestamp(key, date);
    }

    public SLog ts(String key, long date) {
        return this.timestamp(key, new Date(date));
    }

    public SLog append(MapValue m) {
        SLog slog = this;
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = m.entries();
        block4: while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            switch (ent.getValue().getValueType()) {
                case 20: 
                case 21: 
                case 22: 
                case 46: {
                    slog.append(ent.getKey(), ((Number)((Object)ent.getValue())).longValue());
                    continue block4;
                }
                case 30: 
                case 40: 
                case 82: {
                    slog.append(ent.getKey(), ((Number)((Object)ent.getValue())).doubleValue());
                    continue block4;
                }
            }
            slog.append(ent.getKey(), ent.getValue().toString());
        }
        return slog;
    }

    public SLog yellow(MapValue m) {
        SLog slog = this;
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = m.entries();
        block5: while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            switch (ent.getValue().getValueType()) {
                case 20: 
                case 21: 
                case 22: 
                case 46: {
                    slog.yellow(ent.getKey(), (Object)AnsiPrint.yellow(((Number)((Object)ent.getValue())).longValue()));
                    continue block5;
                }
                case 30: {
                    slog.yellow(ent.getKey(), ((Number)((Object)ent.getValue())).floatValue());
                    continue block5;
                }
                case 40: 
                case 82: {
                    slog.yellow(ent.getKey(), ((Number)((Object)ent.getValue())).doubleValue());
                    continue block5;
                }
            }
            slog.yellow(ent.getKey(), (Object)ent.getValue());
        }
        return slog;
    }

    public SLog append(MapValue m, Fmt keyfmt, Fmt valfmt) {
        SLog slog = this;
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = m.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            slog.append(keyfmt.format(ent.getKey()), valfmt.format(ent.getValue()));
        }
        return slog;
    }

    public SLog append(MapValue m, String prefix) {
        if (m == null) {
            return this;
        }
        SLog slog = this;
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = m.entries();
        block4: while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            switch (ent.getValue().getValueType()) {
                case 20: 
                case 21: 
                case 22: 
                case 46: {
                    slog.append(ent.getKey() + prefix, ((Number)((Object)ent.getValue())).longValue());
                    continue block4;
                }
                case 30: 
                case 40: 
                case 82: {
                    slog.append(ent.getKey() + prefix, ((Number)((Object)ent.getValue())).doubleValue());
                    continue block4;
                }
            }
            slog.append(ent.getKey() + prefix, ent.getValue().toString());
        }
        return slog;
    }

    public SLog append(MapValue m, Map<String, Type> types) {
        SLog slog = this;
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = m.entries();
        block9: while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            Type t = types.get(ent.getKey());
            if (t != null) {
                switch (t) {
                    case date: {
                        slog.date(ent.getKey(), new Date(CastUtil.clong(ent.getValue())));
                        break;
                    }
                    case time: {
                        slog.time(ent.getKey(), new Date(CastUtil.clong(ent.getValue())));
                        break;
                    }
                    case timestamp: {
                        slog.timestamp(ent.getKey(), new Date(CastUtil.clong(ent.getValue())));
                    }
                }
                continue;
            }
            switch (ent.getValue().getValueType()) {
                case 20: 
                case 21: 
                case 22: 
                case 46: {
                    slog.append(ent.getKey(), ((Number)((Object)ent.getValue())).longValue());
                    continue block9;
                }
                case 30: 
                case 40: 
                case 82: {
                    slog.append(ent.getKey(), ((Number)((Object)ent.getValue())).doubleValue());
                    continue block9;
                }
            }
            slog.append(ent.getKey(), ent.getValue().toString());
        }
        return slog;
    }

    public SLog append(Map m) {
        SLog slog = this;
        for (Map.Entry ent : m.entrySet()) {
            if (ent.getValue() instanceof Number) {
                if (ent.getValue() instanceof Long || ent.getValue() instanceof Integer) {
                    slog.append(this.noSpace(ent.getKey().toString()), ((Number)ent.getValue()).longValue());
                    continue;
                }
                slog.append(this.noSpace(ent.getKey().toString()), ((Number)ent.getValue()).doubleValue());
                continue;
            }
            slog.append(this.noSpace(ent.getKey().toString()), ent.getValue().toString());
        }
        return slog;
    }

    private String noSpace(String v) {
        boolean notMod = true;
        char[] k = v.toCharArray();
        for (int i = 0; i < k.length; ++i) {
            if (k[i] != ' ') continue;
            notMod = false;
            k[i] = 95;
        }
        return notMod ? v : new String(k);
    }

    public SLog append(Map m, String prefix) {
        SLog slog = this;
        for (Map.Entry ent : m.entrySet()) {
            if (ent.getValue() instanceof Number) {
                if (ent.getValue() instanceof Long || ent.getValue() instanceof Integer) {
                    slog.append(this.noSpace(prefix + ent.getKey()), ((Number)ent.getValue()).longValue());
                    continue;
                }
                slog.append(this.noSpace(prefix + ent.getKey()), ((Number)ent.getValue()).doubleValue());
                continue;
            }
            slog.append(this.noSpace(prefix + ent.getKey()), ent.getValue().toString());
        }
        return slog;
    }

    public String str() {
        return this.toString();
    }

    public SLog a(Object ... kv) {
        return this.append(kv);
    }

    public SLog a(String key, String value) {
        return this.append(key, value);
    }

    public SLog a(String key, long value) {
        return this.append(key, value);
    }

    public SLog a(String key, double value) {
        return this.append(key, value);
    }

    public SLog a(String key, Object value) {
        return this.append(key, value);
    }

    public SLog red(String key, Object value) {
        return this.append(key, AnsiPrint.red(value));
    }

    public SLog yellow(String key, Object value) {
        return this.append(key, AnsiPrint.yellow(value));
    }

    public SLog green(String key, Object value) {
        return this.append(key, AnsiPrint.green(value));
    }

    public SLog a(Map value) {
        return this.append(value);
    }

    public SLog a(MapValue value) {
        return this.append(value);
    }

    public SLog a(Map m, String prefix) {
        return this.append(m, prefix);
    }

    public SLog a(MapValue m, String prefix) {
        return this.append(m, prefix);
    }

    public static SLog n(String key, String value) {
        return SLog.New(key, value);
    }

    public static SLog n(String key, Object value) {
        return SLog.New(key, value);
    }

    public static SLog n(String key, long value) {
        return SLog.New(key, value);
    }

    public static SLog n(String key, double value) {
        return SLog.New(key, value);
    }

    public static SLog New(String key, String value) {
        return new SLog().append(key, value);
    }

    public static SLog New(String key, Object value) {
        return new SLog().append(key, value);
    }

    public static SLog New(String key, long value) {
        return new SLog().append(key, value);
    }

    public static SLog New(String key, double value) {
        return new SLog().append(key, value);
    }

    public SLog append(SMap m) {
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<String>> sn = m.buffer.entries();
        while (sn.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<String> et = sn.nextElement();
            this.buffer.append(' ');
            this.buffer.append(et.getKey()).append('=');
            this.buffer.append(et.getValue());
        }
        return this;
    }

    public SLog append(SMap m, String prefix) {
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<String>> sn = m.buffer.entries();
        while (sn.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<String> et = sn.nextElement();
            this.buffer.append(' ');
            this.buffer.append(prefix).append(et.getKey()).append('=');
            this.buffer.append(et.getValue());
        }
        return this;
    }

    public SLog append(Object ... kv) {
        if (kv == null || kv.length < 2) {
            return this;
        }
        try {
            int max = kv.length / 2 * 2;
            for (int i = 0; i < max; i += 2) {
                this.append((String)kv[i], kv[i + 1]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public SLog yellow(Object ... kv) {
        if (kv == null || kv.length < 2) {
            return this;
        }
        try {
            int max = kv.length / 2 * 2;
            for (int i = 0; i < max; i += 2) {
                this.yellow((String)kv[i], kv[i + 1]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public SLog a(SMap m) {
        return this.append(m);
    }

    public SLog a(SMap m, String prefix) {
        return this.append(m, prefix);
    }

    public String red() {
        return AnsiPrint.red(this.str());
    }

    public String yellow() {
        return AnsiPrint.yellow(this.str());
    }

    public String green() {
        return AnsiPrint.green(this.str());
    }

    public String cyan() {
        return AnsiPrint.cyan(this.str());
    }
}

