/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack.open;

import java.util.ArrayList;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.pack.open.OpenMx;
import whatap.lang.slog.SLog;
import whatap.util.ArrayUtil;
import whatap.util.CompressUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMxPack
extends AbstractPack {
    private byte zip;
    private byte[] bytes;
    private List<OpenMx> records;

    @Override
    public short getPackType() {
        return 5635;
    }

    @Override
    public String toString() {
        SLog slog = SLog.n("pack", this.getClass().getSimpleName());
        super.slog(slog);
        slog.a("zip", this.zip);
        slog.a("bytes", ArrayUtil.len(this.bytes));
        return slog.green();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        if (this.bytes == null) {
            this.reset(this.records);
        }
        dout.writeByte(this.zip);
        dout.writeBlob(this.bytes);
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        this.zip = din.readByte();
        this.bytes = din.readBlob();
        return this;
    }

    public OpenMxPack setRecords(List<OpenMx> items) {
        this.records = items;
        return this.reset(items);
    }

    private OpenMxPack reset(List<OpenMx> items) {
        DataOutputX o = new DataOutputX();
        o.writeByte(0);
        if (items == null) {
            o.writeShort(0);
        } else {
            o.writeShort(items.size());
            for (int i = 0; i < items.size(); ++i) {
                items.get(i).write(o);
            }
        }
        this.bytes = o.toByteArray();
        if (this.bytes.length > 100) {
            this.zip = 1;
            this.bytes = CompressUtil.doZip(this.bytes);
        }
        return this;
    }

    public List<OpenMx> getRecords() {
        if (this.bytes == null) {
            return null;
        }
        DataInputX in = this.zip == 1 ? new DataInputX(CompressUtil.unZip(this.bytes)) : new DataInputX(this.bytes);
        this.records = new ArrayList<OpenMx>();
        byte ver = in.readByte();
        int size = in.readShort() & 0xFFFF;
        for (int i = 0; i < size; ++i) {
            this.records.add(new OpenMx().read(in));
        }
        return this.records;
    }
}

