/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack.open;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.pack.open.OpenMxHelp;
import whatap.lang.slog.SLog;
import whatap.util.ArrayUtil;
import whatap.util.CompressUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMxHelpPack
extends AbstractPack {
    private byte zip;
    private byte[] bytes;
    private List<OpenMxHelp> records;

    @Override
    public short getPackType() {
        return 5636;
    }

    @Override
    public String toString() {
        SLog slog = SLog.n("pack", this.getClass().getSimpleName());
        super.slog(slog);
        slog.a("zip", this.zip);
        slog.a("bytes", ArrayUtil.len(this.bytes));
        return slog.green();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        if (this.bytes == null) {
            this.reset(this.records);
        }
        dout.writeByte(this.zip);
        dout.writeBlob(this.bytes);
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        this.zip = din.readByte();
        this.bytes = din.readBlob();
        return this;
    }

    public OpenMxHelpPack setRecords(List<OpenMxHelp> items) {
        this.records = items;
        return this.reset(items);
    }

    private OpenMxHelpPack reset(List<OpenMxHelp> items) {
        DataOutputX o = new DataOutputX();
        o.writeByte(0);
        if (items == null) {
            o.writeShort(0);
        } else {
            o.writeShort(items.size());
            for (int i = 0; i < items.size(); ++i) {
                items.get(i).write(o);
            }
        }
        this.bytes = o.toByteArray();
        if (this.bytes.length > 100) {
            this.zip = 1;
            this.bytes = CompressUtil.doZip(this.bytes);
        }
        return this;
    }

    public List<OpenMxHelp> getUnpack() {
        if (this.bytes == null) {
            return Collections.EMPTY_LIST;
        }
        DataInputX in = this.zip == 1 ? new DataInputX(CompressUtil.unZip(this.bytes)) : new DataInputX(this.bytes);
        this.records = new ArrayList<OpenMxHelp>();
        byte ver = in.readByte();
        int size = in.readShort() & 0xFFFF;
        for (int i = 0; i < size; ++i) {
            this.records.add(new OpenMxHelp().read(in));
        }
        return this.records;
    }

    public List<OpenMxHelp> getRecords() {
        if (this.bytes == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.records == null) {
            return this.getUnpack();
        }
        return this.records;
    }
}

