/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.util.HashUtil;

public class LogSinkPack
extends AbstractPack {
    public String category;
    public long tagHash;
    public MapValue tags = new MapValue();
    public long line;
    public String content;
    public MapValue fields = new MapValue();
    public transient boolean dropped;

    public short getPackType() {
        return 5898;
    }

    public String toString() {
        return super.toString() + " [category=" + this.category + ", tagHash=" + this.tagHash + ", tags=" + this.tags + ", content=" + this.content + ", fields=" + this.fields + "]";
    }

    public byte[] getTagAsBytes() {
        DataOutputX out = new DataOutputX();
        out.writeValue(this.tags);
        return out.toByteArray();
    }

    public byte[] getContentBytes() {
        DataOutputX o = new DataOutputX();
        o.writeByte(1);
        o.writeText(this.content);
        o.writeDecimal(this.line);
        return o.toByteArray();
    }

    public void putCtr(String key, Value value) {
        if (key.charAt(0) == '!') {
            this.fields.put(key, value);
        }
    }

    public Value getCtr(String key) {
        return this.fields.get(key);
    }

    public boolean getCtrBoolean(String key) {
        Value v = this.fields.get(key);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return false;
    }

    public String content() {
        return this.content == null ? "" : this.content;
    }

    public void content(String str) {
        this.content = str;
    }

    public void setContentBytes(byte[] d) {
        try {
            if (d == null || d.length < 1) {
                return;
            }
            DataInputX in = new DataInputX(d);
            byte ver = in.readByte();
            if (ver == 1) {
                this.content = in.readText();
                this.line = in.readDecimal();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeByte(0);
        dout.writeText(this.category);
        dout.writeDecimal(this.tagHash);
        dout.writeValue(this.tags);
        dout.writeDecimal(this.line);
        dout.writeText(this.content);
        if (this.fields.size() > 0) {
            dout.writeBoolean(true);
            dout.writeValue(this.fields);
        } else {
            dout.writeBoolean(false);
        }
    }

    public Pack read(DataInputX din) {
        super.read(din);
        byte ver = din.readByte();
        this.category = din.readText();
        this.tagHash = din.readDecimal();
        this.tags = (MapValue)din.readValue();
        this.line = din.readDecimal();
        this.content = din.readText();
        if (din.readBoolean()) {
            this.fields = (MapValue)din.readValue();
        }
        return this;
    }

    public byte[] resetTagHash() {
        DataOutputX out = new DataOutputX();
        out.writeValue(this.tags);
        byte[] tagBytes = out.toByteArray();
        this.tagHash = HashUtil.hash64(tagBytes);
        return tagBytes;
    }

    public void transferOidToTag() {
        if (this.oid != 0 && !this.tags.containsKey("oid")) {
            this.tags.put("oid", this.oid);
            this.tagHash = 0L;
        }
        if (this.okind != 0 && !this.tags.containsKey("okind")) {
            this.tags.put("okind", this.okind);
            this.tagHash = 0L;
        }
        if (this.onode != 0 && !this.tags.containsKey("onode")) {
            this.tags.put("onode", this.onode);
            this.tagHash = 0L;
        }
    }
}

