/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.Enumeration;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.EventLevel;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;
import whatap.util.UUIDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventPack
extends AbstractPack {
    private static final String ESCALATION_KEY = "_esca_";
    private static final String UUID_KEY = "_uuid_";
    private static final String STATUS_KEY = "_status_";
    private static final String OTYPE_KEY = "_otype_";
    public String uuid;
    public boolean escalation;
    public byte level;
    public String title;
    public String message;
    public int status;
    public int otype;
    public StringKeyLinkedMap<String> attr = new StringKeyLinkedMap();
    public long eid;

    public int size() {
        int size = 1;
        size += this.title == null ? 0 : this.title.length();
        size += this.message == null ? 0 : this.message.length();
        return size += this.attr.size() * 20;
    }

    @Override
    public short getPackType() {
        return 5120;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALERT ");
        sb.append(super.toString());
        sb.append(" " + EventLevel.values.get(this.level));
        sb.append(" " + this.title);
        sb.append(" " + this.message);
        sb.append(" " + this.attr);
        return sb.toString();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeByte(this.level);
        dout.writeText(this.title);
        dout.writeText(this.message);
        if (StringUtil.isNotEmpty(this.uuid)) {
            this.attr.put(UUID_KEY, this.uuid);
        }
        this.attr.put(ESCALATION_KEY, this.escalation ? "true" : "false");
        this.attr.put(STATUS_KEY, String.valueOf(this.status));
        this.attr.put(OTYPE_KEY, String.valueOf(this.otype));
        dout.writeByte(this.attr.size());
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<String>> en = this.attr.entries();
        for (int i = 0; i < this.attr.size(); ++i) {
            StringKeyLinkedMap.StringKeyLinkedEntry<String> e = en.nextElement();
            dout.writeText(e.getKey());
            dout.writeText(e.getValue());
        }
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        this.level = din.readByte();
        this.title = din.readText();
        this.message = din.readText();
        int tagsz = din.readUnsignedByte();
        for (int i = 0; i < tagsz; ++i) {
            String key = din.readText();
            String value = din.readText();
            this.attr.put(key, value);
        }
        this.escalation = "true".equals(this.attr.remove(ESCALATION_KEY));
        this.uuid = this.attr.remove(UUID_KEY);
        this.otype = CastUtil.cint(this.attr.remove(OTYPE_KEY));
        this.status = CastUtil.cint(this.attr.remove(STATUS_KEY));
        return this;
    }

    public void setUuid() {
        if (StringUtil.isNotEmpty(this.uuid)) {
            return;
        }
        this.uuid = UUIDUtil.generate();
    }

    public byte getLevel() {
        return this.level;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public StringKeyLinkedMap<String> getAttr() {
        return this.attr;
    }

    public long getEventId() {
        if (this.eid == 0L) {
            this.eid = StringUtil.isNotEmpty(this.uuid) ? UUIDUtil.toLong(this.uuid) : DateUtil.currentTime();
        }
        return this.eid;
    }
}

