/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.WsKey;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.value.MapValue;
import whatap.util.AnsiPrint;
import whatap.util.CastUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentPropertyPack
extends AbstractPack {
    protected StringKeyLinkedMap<String> ctr = new StringKeyLinkedMap();
    protected StringKeyLinkedMap<String> table = new StringKeyLinkedMap();

    public int size() {
        return this.table.size();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }

    public StringEnumer keys() {
        return this.table.keys();
    }

    public String[] keyArray() {
        return this.table.keyArray();
    }

    public String get(String key) {
        return this.table.get(key);
    }

    public MapValue getPropertyAsMapValue() {
        MapValue m = new MapValue();
        StringEnumer en = this.table.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            String val = this.table.get(key);
            m.put(key, val);
        }
        return m;
    }

    public int getInt(String key) {
        String v = this.get(key);
        return CastUtil.cint(v);
    }

    public long getLong(String key) {
        String v = this.get(key);
        return CastUtil.clong(v);
    }

    public float getFloat(String key) {
        String v = this.get(key);
        return CastUtil.cfloat(v);
    }

    public String put(String key, String value) {
        return this.table.put(key, value);
    }

    public void putAll(MapValue map) {
        if (map == null) {
            return;
        }
        StringEnumer en = map.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            this.table.put(key, CastUtil.cString(map.get(key)));
        }
    }

    public void putAll(StringKeyLinkedMap<String> map) {
        if (map != null) {
            this.table.putAll(map);
        }
    }

    public String remove(String key) {
        return this.table.remove(key);
    }

    public void clear() {
        this.table.clear();
    }

    public void putCtr(String key, String value) {
        this.ctr.put(key, value);
    }

    public String getCtr(String key) {
        return this.ctr.get(key);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("AgentProperty ");
        buf.append("wskey=");
        buf.append(AnsiPrint.green(WsKey.toString(this.pcode)));
        buf.append(",oid=").append(AnsiPrint.green(this.oid));
        buf.append(",okind=").append(AnsiPrint.green(this.okind));
        buf.append(",onode=").append(AnsiPrint.green(this.onode));
        StringEnumer en = this.table.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            buf.append(" ").append(key).append("=").append(this.table.get(key));
        }
        return buf.toString();
    }

    public StringBuilder toPropertyString(StringBuilder sb) {
        StringEnumer en = this.table.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            String val = this.table.get(key);
            sb.append(" ").append(key).append("=").append(val);
        }
        return sb;
    }

    @Override
    public short getPackType() {
        return 5902;
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeByte(0);
        this.writeTable(dout, this.ctr);
        this.writeTable(dout, this.table);
    }

    private void writeTable(DataOutputX dout, StringKeyLinkedMap<String> t) {
        dout.writeDecimal(t.size());
        StringEnumer en = t.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            String val = t.get(key);
            dout.writeText(key);
            dout.writeText(val);
        }
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        byte ver = din.readByte();
        this.ctr = this.readTable(din);
        this.table = this.readTable(din);
        return this;
    }

    private StringKeyLinkedMap<String> readTable(DataInputX din) {
        StringKeyLinkedMap<String> o = new StringKeyLinkedMap<String>();
        int sz = (int)din.readDecimal();
        for (int i = 0; i < sz; ++i) {
            String k = din.readText();
            String v = din.readText();
            o.put(k, v);
        }
        return o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public AgentPropertyPack setMapValue(MapValue mapValue) {
        if (mapValue == null) {
            return this;
        }
        this.putAll(mapValue);
        return this;
    }

    @Override
    public String toFormatString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toFormatString());
        StringEnumer en = this.table.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            buf.append("\t").append(key).append("=").append(this.table.get(key)).append("\n");
        }
        return buf.toString();
    }
}

