/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.Arrays;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;

public class ActiveStackPack1
extends AbstractPack {
    public long activeStackId;
    public long txid;
    public int service;
    public int[] callstack;
    public int callstack_hash;
    public int elapsed;
    public boolean perfx_included = false;
    public int client_ip;
    public int cputime;
    public long malloc;
    public int sql_count;
    public int sql_time;
    public int active_sql_dbc;
    public int active_sql_hash;
    public int rs_count;
    public int rs_time;
    public int httpc_count;
    public int httpc_time;
    public int active_httpc_hash;
    public String thread_name;

    public short getPackType() {
        return 1025;
    }

    public void write(DataOutputX o) {
        super.write(o);
        byte ver = (byte)(this.thread_name == null ? 2 : 3);
        o.writeByte(ver);
        o.writeLong(this.activeStackId);
        o.writeLong(this.txid);
        o.writeInt(this.service);
        o.writeInt(this.callstack_hash);
        o.writeArray(this.callstack);
        o.writeDecimal(this.elapsed);
        o.writeBoolean(this.perfx_included);
        if (this.perfx_included) {
            o.writeDecimal(this.client_ip);
            o.writeDecimal(this.cputime);
            o.writeDecimal(this.malloc);
            o.writeDecimal(this.sql_count);
            o.writeDecimal(this.sql_time);
            o.writeDecimal(this.active_sql_dbc);
            o.writeDecimal(this.active_sql_hash);
            o.writeDecimal(this.rs_count);
            o.writeDecimal(this.rs_time);
            o.writeDecimal(this.httpc_count);
            o.writeDecimal(this.httpc_time);
            o.writeDecimal(this.active_httpc_hash);
        }
        if (ver >= 3) {
            DataOutputX dout = new DataOutputX();
            dout.writeText(this.thread_name);
            o.writeBlob(dout.toByteArray());
        }
    }

    public Pack read(DataInputX din) {
        super.read(din);
        byte ver = din.readByte();
        this.activeStackId = din.readLong();
        this.txid = din.readLong();
        this.service = din.readInt();
        this.callstack_hash = din.readInt();
        this.callstack = din.readArray(this.callstack);
        switch (ver) {
            case 0: {
                return this;
            }
            case 1: {
                this.elapsed = (int)din.readDecimal();
                return this;
            }
        }
        this.elapsed = (int)din.readDecimal();
        this.perfx_included = din.readBoolean();
        if (this.perfx_included) {
            this.client_ip = (int)din.readDecimal();
            this.cputime = (int)din.readDecimal();
            this.malloc = din.readDecimal();
            this.sql_count = (int)din.readDecimal();
            this.sql_time = (int)din.readDecimal();
            this.active_sql_dbc = (int)din.readDecimal();
            this.active_sql_hash = (int)din.readDecimal();
            this.rs_count = (int)din.readDecimal();
            this.rs_time = (int)din.readDecimal();
            this.httpc_count = (int)din.readDecimal();
            this.httpc_time = (int)din.readDecimal();
            this.active_httpc_hash = (int)din.readDecimal();
        }
        if (ver >= 3) {
            DataInputX din2 = new DataInputX(din.readBlob());
            this.thread_name = din2.readText();
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActiveStackPack1");
        builder.append(super.toString());
        builder.append("[seq=");
        builder.append(this.activeStackId);
        builder.append(", txid=");
        builder.append(this.txid);
        builder.append(", service=");
        builder.append(this.service);
        builder.append(", callstack=");
        builder.append(Arrays.toString(this.callstack));
        builder.append(", callstack_hash=");
        builder.append(this.callstack_hash);
        builder.append(", elapsed=");
        builder.append(this.elapsed);
        builder.append(", perfx_included=");
        builder.append(this.perfx_included);
        builder.append("]");
        return builder.toString();
    }

    public static void main(String[] args) {
        ActiveStackPack1 pp = new ActiveStackPack1();
        pp.callstack = new int[100];
        pp = (ActiveStackPack1)new DataInputX(new DataOutputX().writePack(pp).toByteArray()).readPack();
        System.out.println(pp);
    }
}

