/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.util;

import whatap.agent.conf.ConfLog;
import whatap.util.DateTimeHelper;
import whatap.util.DateUtil;

public class LogFormat {
    protected static final String WHATA_AGENT_LOGGER = "whatap.agent.Logger";
    protected static final StackTraceElement EMPTY_STACK_ELEMENT = new StackTraceElement("", "", "", 0);
    public static DateTimeHelper dateHelper = DateUtil.helper;

    static StackTraceElement extract(Throwable t) {
        StackTraceElement[] se = t.getStackTrace();
        int max = se.length - 1;
        for (int i = 0; i < max; ++i) {
            if (!WHATA_AGENT_LOGGER.equals(se[i].getClassName())) continue;
            return se[i + 1];
        }
        return EMPTY_STACK_ELEMENT;
    }

    private static String getCaller() {
        Throwable t = new Throwable();
        StackTraceElement se = LogFormat.extract(t);
        if (se == EMPTY_STACK_ELEMENT) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(LogFormat.lastWord(se.getClassName(), '.'));
        sb.append('.').append(se.getMethodName());
        sb.append('(').append(se.getLineNumber()).append(')');
        return sb.toString();
    }

    private static char[] lastWord(String s, char c) {
        int x = s.lastIndexOf(46);
        if (x > 0) {
            char[] out = new char[s.length() - ++x];
            s.getChars(x, s.length(), out, 0);
            return out;
        }
        return s.toCharArray();
    }

    public static void main(String[] args) {
        String nm = LogFormat.class.getName();
        char[] o = LogFormat.lastWord(nm, '.');
        StringBuilder b = new StringBuilder();
        b.append(o);
        System.out.println("[" + b + "]");
    }

    public static String build(String oname, String id, String message) {
        StringBuilder sb = new StringBuilder(151);
        sb.append(dateHelper.datetime(System.currentTimeMillis())).append(" ");
        if (ConfLog.log_oname_enabled) {
            sb.append("[").append(oname).append("]");
        }
        if (ConfLog.log_thread_enabled) {
            sb.append("[").append("\u001b[32m").append(Thread.currentThread().getName()).append("\u001b[0m").append("]");
        }
        if (ConfLog.log_caller_enabled) {
            sb.append("[").append("\u001b[33m").append(LogFormat.getCaller()).append("\u001b[0m").append("] ");
        }
        sb.append("(").append(id).append(") ").append(message);
        return sb.toString();
    }

    public static String build(String oname, String message) {
        StringBuilder sb = new StringBuilder(51);
        sb.append(dateHelper.datetime(System.currentTimeMillis())).append(" ");
        if (ConfLog.log_oname_enabled) {
            sb.append("[").append(oname).append("]");
        }
        if (ConfLog.log_thread_enabled) {
            sb.append("[").append("\u001b[32m").append(Thread.currentThread().getName()).append("\u001b[0m").append("]");
        }
        if (ConfLog.log_caller_enabled) {
            sb.append("[").append("\u001b[33m").append(LogFormat.getCaller()).append("\u001b[0m").append("] ");
        }
        sb.append(message);
        return sb.toString();
    }
}

