/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.sql;

import whatap.agent.Logger;
import whatap.agent.api.trace.TxTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataTextAgent;
import whatap.agent.stat.ErrorArg;
import whatap.agent.stat.StatError;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.exception.ExceptionAlert;
import whatap.agent.trace.sql.TraceSQL;
import whatap.lang.step.SqlStepX;
import whatap.notice.WHATAP_ERROR;
import whatap.util.IntKeyLinkedMap;

public class TraceSQLHelper {
    private static IntKeyLinkedMap<String> dbProductCache = new IntKeyLinkedMap().setMax(100);

    public static boolean isContextDetached(TraceContext ctx) {
        return ctx.closed || TraceContextManager.getContext(ctx.txid) == null;
    }

    static String buildDetachedSqlServiceName(TraceContext ctx, int dbcHash, String sql) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        sb.append(TraceSQLHelper.extractDatabaseProduct(dbcHash));
        sb.append(".");
        sb.append(TraceSQLHelper.extractSqlOperation(sql).toLowerCase());
        sb.append("]");
        if (ctx.service_name != null && ctx.service_name.length() > 0) {
            sb.append(" ").append(ctx.service_name);
        }
        if (ConfTrace.trace_sql_detached_suffix != null && ConfTrace.trace_sql_detached_suffix.length() > 0) {
            sb.append(ConfTrace.trace_sql_detached_suffix);
        }
        return sb.toString();
    }

    static String extractDatabaseProduct(int dbcHash) {
        if (dbcHash == 0) {
            return "db";
        }
        String cached = dbProductCache.get(dbcHash);
        if (cached != null) {
            return cached;
        }
        String url = DataTextAgent.DbcUrlMap.get(dbcHash);
        if (url == null || url.length() < 6) {
            return "db";
        }
        if (!url.startsWith("jdbc:")) {
            return "db";
        }
        int start = 5;
        int end = url.indexOf(58, start);
        if (end == -1) {
            end = Math.min(url.length(), start + 20);
        }
        if (end <= start) {
            return "db";
        }
        String vendor = url.substring(start, end);
        String result = vendor.startsWith("mysql") ? "mysql" : (vendor.startsWith("mariadb") ? "mariadb" : (vendor.startsWith("postgres") ? "postgresql" : (vendor.startsWith("oracle") ? "oracle" : (vendor.startsWith("sqlserver") || vendor.startsWith("microsoft") ? "sqlserver" : (vendor.startsWith("db2") ? "db2" : (vendor.startsWith("h2") ? "h2" : (vendor.startsWith("hsql") ? "hsqldb" : (vendor.startsWith("derby") ? "derby" : (vendor.startsWith("sqlite") ? "sqlite" : (vendor.startsWith("mongo") ? "mongodb" : (vendor.startsWith("redis") ? "redis" : (vendor.startsWith("tibero") ? "tibero" : (vendor.startsWith("altibase") ? "altibase" : (vendor.startsWith("cubrid") ? "cubrid" : (vendor.length() <= 15 ? vendor : "db")))))))))))))));
        dbProductCache.put(dbcHash, result);
        return result;
    }

    static String extractSqlOperation(String sql) {
        int i;
        if (sql == null) {
            return "QUERY";
        }
        int len = sql.length();
        if (len < 6) {
            return "QUERY";
        }
        for (i = 0; i < len && Character.isWhitespace(sql.charAt(i)); ++i) {
        }
        if (i >= len) {
            return "QUERY";
        }
        int limit = Math.min(i + 10, len);
        char c0 = Character.toUpperCase(sql.charAt(i));
        String result = null;
        switch (c0) {
            case 'S': {
                if (!TraceSQLHelper.matchKeyword(sql, i, limit, "SELECT")) break;
                result = "SELECT";
                break;
            }
            case 'I': {
                if (!TraceSQLHelper.matchKeyword(sql, i, limit, "INSERT")) break;
                result = "INSERT";
                break;
            }
            case 'U': {
                if (!TraceSQLHelper.matchKeyword(sql, i, limit, "UPDATE")) break;
                result = "UPDATE";
                break;
            }
            case 'D': {
                if (!TraceSQLHelper.matchKeyword(sql, i, limit, "DELETE")) break;
                result = "DELETE";
                break;
            }
            case 'C': {
                if (!TraceSQLHelper.matchKeyword(sql, i, limit, "CALL")) break;
                result = "CALL";
                break;
            }
            case 'E': {
                if (!TraceSQLHelper.matchKeyword(sql, i, limit, "EXEC")) break;
                result = "EXEC";
                break;
            }
            case 'M': {
                if (!TraceSQLHelper.matchKeyword(sql, i, limit, "MERGE")) break;
                result = "MERGE";
                break;
            }
            case 'R': {
                if (!TraceSQLHelper.matchKeyword(sql, i, limit, "REPLACE")) break;
                result = "REPLACE";
                break;
            }
            case 'T': {
                if (!TraceSQLHelper.matchKeyword(sql, i, limit, "TRUNCATE")) break;
                result = "TRUNCATE";
            }
        }
        if (result == null) {
            result = "QUERY";
        }
        return result;
    }

    static boolean matchKeyword(String sql, int start, int limit, String keyword) {
        char nextChar;
        int keyLen = keyword.length();
        if (start + keyLen > limit || start + keyLen > sql.length()) {
            return false;
        }
        for (int i = 0; i < keyLen; ++i) {
            if (Character.toUpperCase(sql.charAt(start + i)) == keyword.charAt(i)) continue;
            return false;
        }
        return start + keyLen >= sql.length() || Character.isWhitespace(nextChar = sql.charAt(start + keyLen));
    }

    static void addSqlStepAndEnd(TraceContext ctx, SqlStepX step, Throwable thr) {
        try {
            step.start_time = 0;
            if (thr != null && ConfTrace.trace_sql_exception_enabled) {
                int sqlErrorCode = TraceSQL.isql.getErrorCode(thr);
                if (sqlErrorCode == 0 || !ConfTrace.ignore_sql_error_code_set.contains(sqlErrorCode)) {
                    ErrorArg arg = new ErrorArg();
                    arg.exception = thr;
                    arg.message = thr.getMessage();
                    arg.setTraceCtx(ctx);
                    arg.sqlErrorCode = sqlErrorCode;
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                    ExceptionAlert.getInstance().jdbc(ctx, ctx.sqlText, arg);
                    ctx.handleSqlErrorStack(thr);
                }
            } else if (step.elapsed > ConfTrace.trace_error_sql_time_max) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.slow_sql;
                arg.message = WHATAP_ERROR.slow_sql.getMessage();
                arg.setTraceCtx(ctx);
                arg.appendSql(step.hash);
                step.error = StatError.getInstance().addError(arg);
                ExceptionAlert.getInstance().jdbc(ctx, ctx.sqlText, arg);
            }
            ctx.profile.add(step);
            ctx.executed_dbc = step.dbc;
            ctx.executed_sqlhash = step.hash;
            ++ctx.sql_count;
            ctx.sql_time += step.elapsed;
            TxTrace.endSqlTx(ctx, thr);
        }
        catch (Throwable t) {
            Logger.println("TR-SQL-END", 30, "Failed to add SQL step and end trace", t);
        }
    }
}

