/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.httpc;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.plugin.PluginHttpCallEnd;
import whatap.agent.plugin.PluginHttpCallStart;
import whatap.agent.proxy.HttpClient43Factory;
import whatap.agent.proxy.IHttpClient;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.httpc.HttpcTraceHelper;
import whatap.agent.trace.httpc.urlnorm.HttpcUrlNorm;
import whatap.lang.step.HttpcStepX;
import whatap.util.IntKeyLinkedMap;

public class ForHttpClient40
implements HttpcTraceHelper.IHelper {
    Configure conf = Configure.getInstance();
    private boolean ok = true;
    private static IntKeyLinkedMap<IHttpClient> httpclients = new IntKeyLinkedMap().setMax(5);

    public boolean start(TraceContext ctx, HttpcStepX step, HookArgs hookPoint) {
        step.driver = "ApacheClient";
        try {
            if (!this.ok) {
                ctx.httpc_url = hookPoint.class1 + "." + hookPoint.method;
            } else if (hookPoint.args != null && hookPoint.args.length >= 2) {
                IHttpClient httpclient = this.getProxy(hookPoint);
                ctx.httpc_host = httpclient.getHost(hookPoint.args[0]);
                ctx.httpc_port = httpclient.getPort(hookPoint.args[0]);
                ctx.httpc_url = httpclient.getURI(hookPoint.args[1]);
                ctx.httpc_url = ConfTrace.trace_origin_httpc_enabled ? HttpcUrlNorm.normalize(ctx.httpc_url, step) : HttpcUrlNorm.normalize(ctx.httpc_url);
                if ("".equals(ctx.httpc_url)) {
                    ctx.httpc_url = "/";
                }
                this.transfer(httpclient, ctx, step, hookPoint.args[0], hookPoint.args[1]);
                return true;
            }
        }
        catch (Exception e) {
            this.ok = false;
            ctx.httpc_url = e.toString();
        }
        if (ctx.httpc_url == null) {
            ctx.httpc_url = hookPoint.class1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpClient getProxy(HookArgs hookPoint) {
        int key = System.identityHashCode(hookPoint.this1.getClass());
        IHttpClient httpclient = httpclients.get(key);
        if (httpclient == null) {
            ForHttpClient40 forHttpClient40 = this;
            synchronized (forHttpClient40) {
                httpclient = HttpClient43Factory.create(hookPoint.this1.getClass().getClassLoader());
                httpclients.put(key, httpclient);
            }
        }
        return httpclient;
    }

    private void transfer(IHttpClient httpclient, TraceContext ctx, HttpcStepX step, Object host, Object req) {
        try {
            if (ConfMTrace.mtrace_enabled) {
                String traceparent;
                httpclient.addHeader(req, ConfMTrace._trace_mtrace_poid_key, TraceContext.transferPOID());
                if (ConfMTrace.stat_mtrace_enabled) {
                    httpclient.addHeader(req, ConfMTrace._trace_mtrace_spec_key1, ctx.transferSPEC_URL1());
                }
                if (ConfMTrace.mtid_mtrace_enabled && ctx.mtid != 0L) {
                    httpclient.addHeader(req, ConfMTrace._trace_mtrace_caller_key, ctx.transferMTID_CALLERTX(step.stepId));
                }
                if (ConfMTrace.mtrace_traceparent_enabled && (traceparent = ctx.trasferMTID_TRACEPARENT(step.stepId)) != null) {
                    httpclient.addHeader(req, ConfMTrace._trace_mtrace_traceparent_key, traceparent);
                }
            }
            PluginHttpCallStart.process(ctx, httpclient, host, req);
        }
        catch (Throwable e) {
            this.ok = false;
        }
    }

    public HttpcTraceHelper.HttpcEndValue end(TraceContext ctx, HookArgs hookPoint, Throwable thr) {
        if (this.ok && hookPoint.returnValue != null) {
            try {
                HttpcTraceHelper.HttpcEndValue httpcEndValue = new HttpcTraceHelper.HttpcEndValue();
                IHttpClient httpclient = this.getProxy(hookPoint);
                httpcEndValue.exception = thr;
                httpcEndValue.status = httpclient.getStatus(hookPoint.returnValue);
                if (httpcEndValue.status >= 400) {
                    httpcEndValue.status_reason = httpclient.getStatusReason(hookPoint.returnValue);
                }
                PluginHttpCallEnd.process(ctx, httpcEndValue);
                return httpcEndValue;
            }
            catch (Throwable e) {
                this.ok = false;
                Logger.println("A133", 10, e);
            }
        }
        return null;
    }
}

