/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.httpc;

import java.lang.reflect.Method;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.plugin.PluginHttpCallEnd;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.httpc.HttpcTraceHelper;
import whatap.agent.trace.httpc.urlnorm.HttpcUrlNorm;
import whatap.lang.step.HttpcStepX;
import whatap.util.CastUtil;

public class ForHttpClient
implements HttpcTraceHelper.IHelper {
    Configure conf = Configure.getInstance();
    private boolean ok = true;

    public boolean start(TraceContext ctx, HttpcStepX step, HookArgs hookPoint) {
        step.driver = "ApacheClient";
        if (this.ok && hookPoint.args != null && hookPoint.args.length == 3) {
            try {
                Method method = hookPoint.args[1].getClass().getMethod("getURI", new Class[0]);
                Object o = method.invoke(hookPoint.args[1], new Object[0]);
                if (o != null && o.getClass().getName().endsWith("URI")) {
                    Class<?> c = o.getClass();
                    String url = CastUtil.cString(c.getMethod("getPath", new Class[0]).invoke(o, new Object[0]));
                    ctx.httpc_url = ConfTrace.trace_origin_httpc_enabled ? HttpcUrlNorm.normalize(url, step) : HttpcUrlNorm.normalize(url);
                    if ("".equals(ctx.httpc_url)) {
                        ctx.httpc_url = "/";
                    }
                    ctx.httpc_host = CastUtil.cString(c.getMethod("getHost", new Class[0]).invoke(o, new Object[0]));
                    ctx.httpc_port = CastUtil.cint(c.getMethod("getPort", new Class[0]).invoke(o, new Object[0]));
                    if (ctx.httpc_port <= 0) {
                        try {
                            ctx.httpc_port = "https".equals(c.getMethod("getScheme", new Class[0]).invoke(o, new Object[0])) ? 443 : 80;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (ConfMTrace.mtrace_enabled) {
                    String traceparent;
                    method = hookPoint.args[1].getClass().getMethod("addRequestHeader", String.class, String.class);
                    method.invoke(hookPoint.args[1], ConfMTrace._trace_mtrace_poid_key, TraceContext.transferPOID());
                    if (ConfMTrace.stat_mtrace_enabled) {
                        method.invoke(hookPoint.args[1], ConfMTrace._trace_mtrace_spec_key1, ctx.transferSPEC_URL1());
                    }
                    if (ConfMTrace.mtid_mtrace_enabled && ctx.mtid != 0L) {
                        method.invoke(hookPoint.args[1], ConfMTrace._trace_mtrace_caller_key, ctx.transferMTID_CALLERTX(step.stepId));
                    }
                    if (ConfMTrace.mtrace_traceparent_enabled && (traceparent = ctx.trasferMTID_TRACEPARENT(step.stepId)) != null) {
                        method.invoke(hookPoint.args[1], ConfMTrace._trace_mtrace_traceparent_key, traceparent);
                    }
                }
                return true;
            }
            catch (Throwable e) {
                Logger.println("A130", 10, e);
                this.ok = false;
            }
        }
        if (ctx.httpc_url == null) {
            ctx.httpc_url = hookPoint.class1;
        }
        return true;
    }

    public HttpcTraceHelper.HttpcEndValue end(TraceContext ctx, HookArgs hookPoint, Throwable thr) {
        if (this.ok && hookPoint.args != null && hookPoint.args.length == 3) {
            Configure conf = Configure.getInstance();
            try {
                Object httpMethod = hookPoint.args[1];
                HttpcTraceHelper.HttpcEndValue httpcEndValue = new HttpcTraceHelper.HttpcEndValue();
                httpcEndValue.exception = thr;
                Method method = httpMethod.getClass().getMethod("getStatusCode", new Class[0]);
                method.setAccessible(true);
                httpcEndValue.status = CastUtil.cint(method.invoke(httpMethod, new Object[0]));
                if (httpcEndValue.status >= 400) {
                    method = httpMethod.getClass().getMethod("getStatusText", new Class[0]);
                    method.setAccessible(true);
                    httpcEndValue.status_reason = CastUtil.cString(method.invoke(httpMethod, new Object[0]));
                }
                PluginHttpCallEnd.process(ctx, httpcEndValue);
                return httpcEndValue;
            }
            catch (Throwable e) {
                this.ok = false;
                Logger.println("A131", 10, e);
            }
        }
        return null;
    }
}

