/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.exception;

import whatap.agent.Configure;
import whatap.agent.stat.ErrorArg;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.exception.CurHttpCall;
import whatap.agent.trace.exception.DoHttpCall;
import whatap.agent.trace.exception.DoJdbc;
import whatap.agent.trace.exception.DoService;
import whatap.util.RequestQueue;

public class ExceptionAlert
extends Thread {
    public static final int M_SERVICE = 1;
    public static final int M_HTTPC = 2;
    public static final int M_JDBC = 3;
    private static ExceptionAlert instance;
    static Configure conf;
    private RequestQueue<Item> buffer;
    boolean bRun;

    public ExceptionAlert() {
        this.buffer = new RequestQueue(ExceptionAlert.conf.exception_alert_buffer_size);
        this.bRun = true;
    }

    public static synchronized ExceptionAlert getInstance() {
        if (instance == null) {
            instance = new ExceptionAlert();
            instance.setName("WhaTap-ExceptionAlert");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void httpc(TraceContext ctx, ErrorArg errArg) {
        if (!ExceptionAlert.conf.exception_alert_httpc_enabled) {
            return;
        }
        CurHttpCall ha = new CurHttpCall();
        ha.url = ctx.httpc_url;
        ha.urlhash = ctx.active_httpc_hash;
        ha.hosthash = ctx.httpc_host_hash;
        ha.port = ctx.httpc_port;
        this.buffer.put(new Item(ctx, errArg, ha, 2));
    }

    public void httpc(TraceContext ctx, ErrorArg arg, int status, String status_reason) {
        if (!ExceptionAlert.conf.exception_alert_httpc_enabled) {
            return;
        }
        CurHttpCall ha = new CurHttpCall();
        ha.url = ctx.httpc_url;
        ha.urlhash = ctx.active_httpc_hash;
        ha.hosthash = ctx.httpc_host_hash;
        ha.port = ctx.httpc_port;
        ha.status = status;
        ha.status_reason = status_reason;
        this.buffer.put(new Item(ctx, arg, ha, 2));
    }

    public void service(TraceContext ctx, ErrorArg errArg) {
        if (!ExceptionAlert.conf.exception_alert_service_enabled) {
            return;
        }
        this.buffer.put(new Item(ctx, errArg, 1));
    }

    public void jdbc(TraceContext ctx, String sqltext, ErrorArg errArg) {
        if (!ExceptionAlert.conf.exception_alert_jdbc_enabled) {
            return;
        }
        this.buffer.put(new Item(ctx, errArg, sqltext, 3));
    }

    public void run() {
        while (this.bRun) {
            try {
                Item r = this.buffer.get();
                switch (r.mode) {
                    case 1: {
                        DoService.process(r);
                        break;
                    }
                    case 2: {
                        DoHttpCall.process(r);
                        break;
                    }
                    case 3: {
                        DoJdbc.process(r);
                    }
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static void resetIgnoreRecord() {
        try {
            long base = System.currentTimeMillis() - ExceptionAlert.conf.exception_alert_ignore_reset_time;
            DoService.resetIgnoreRecord(base);
            DoHttpCall.resetIgnoreRecord(base);
            DoJdbc.resetIgnoreRecord(base);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        conf = Configure.getInstance();
    }

    static class TIMECNT {
        long last_alert_time;
        long last_data_time;
        int ignored;

        TIMECNT() {
        }
    }

    static class Item {
        TraceContext ctx;
        ErrorArg arg;
        CurHttpCall httpc;
        int mode;
        String sqltext;
        int sqlErrCode;

        public Item(TraceContext ctx, ErrorArg arg, int mode) {
            this.ctx = ctx;
            this.arg = arg;
            this.mode = mode;
        }

        public Item(TraceContext ctx, ErrorArg arg, CurHttpCall httpc, int mode) {
            this.ctx = ctx;
            this.arg = arg;
            this.httpc = httpc;
            this.mode = mode;
        }

        public Item(TraceContext ctx, ErrorArg arg, String sqltext, int mode) {
            this.ctx = ctx;
            this.arg = arg;
            this.sqlErrCode = arg.sqlErrorCode;
            this.sqltext = sqltext;
            this.mode = mode;
        }
    }
}

