/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.exception;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.data.DataPackSender;
import whatap.agent.trace.exception.ExceptionAlert;
import whatap.agent.trace.exception.UrlEx;
import whatap.lang.pack.EventPack;
import whatap.util.LinkedMap;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class DoJdbc {
    static LinkedMap<UrlEx, ExceptionAlert.TIMECNT> timeMap = new LinkedMap<UrlEx, ExceptionAlert.TIMECNT>(){

        @Override
        protected ExceptionAlert.TIMECNT create(UrlEx key) {
            return new ExceptionAlert.TIMECNT();
        }
    }.setMax(1000);
    static Configure conf = Configure.getInstance();

    static void resetIgnoreRecord(long base) {
        Enumeration<ExceptionAlert.TIMECNT> en = timeMap.values();
        while (en.hasMoreElements()) {
            ExceptionAlert.TIMECNT t = en.nextElement();
            if (t.last_alert_time >= base || t.last_data_time >= base) continue;
            t.ignored = 0;
        }
    }

    public static void process(ExceptionAlert.Item r) {
        if (r.ctx == null) {
            return;
        }
        if (r.arg == null || r.arg.exception == null) {
            return;
        }
        String url = r.ctx.service_name;
        if (url == null) {
            return;
        }
        String className = r.sqlErrCode > 0 ? r.arg.exception.getClass().getName() + "(" + r.sqlErrCode + ")" : r.arg.exception.getClass().getName();
        if (className.startsWith("whatap.")) {
            className.substring(className.lastIndexOf(".") + 1);
        }
        long now = System.currentTimeMillis();
        ExceptionAlert.TIMECNT tm = timeMap.intern(new UrlEx(url, className));
        if (now - tm.last_alert_time < DoJdbc.conf.exception_alert_silent_time) {
            tm.last_data_time = now;
            ++tm.ignored;
            return;
        }
        tm.last_alert_time = now;
        EventPack e = new EventPack();
        e.title = "DB_SQL_EXCEPTION";
        e.level = (byte)20;
        e.status = 1;
        if (r.ctx.origin_url != null) {
            e.attr.put("url", r.ctx.origin_url);
        } else {
            e.attr.put("url", r.ctx.service_name);
        }
        e.attr.put("txid", Long.toString(r.ctx.txid));
        e.attr.put("class", className);
        StringBuffer sb = new StringBuffer();
        sb.append("oname: ").append(SecurityMaster.getInstance().ONAME).append("\n");
        if (r.ctx.origin_url != null) {
            sb.append("url: ").append(r.ctx.origin_url).append("\n");
        } else {
            sb.append("url: ").append(r.ctx.service_name).append("\n");
        }
        sb.append("txid: ").append(r.ctx.txid).append("\n");
        sb.append("class: ").append(className).append("\n");
        if (tm.ignored > 0) {
            e.attr.put("ignored", Integer.toString(tm.ignored));
            sb.append("ignored: ").append(tm.ignored).append("\n");
            tm.ignored = 0;
        }
        if (StringUtil.isNotEmpty(r.arg.message)) {
            sb.append("message: ").append(StringUtil.truncate(r.arg.message, 200)).append("\n");
        }
        if (DoJdbc.conf.exception_alert_jdbc_sql_enabled && StringUtil.isNotEmpty(r.sqltext)) {
            sb.append("sql:\n");
            sb.append(r.sqltext).append("\n");
        }
        if (DoJdbc.conf.exception_alert_jdbc_stack_enabled) {
            sb.append("stack:\n");
            ThreadUtil.getStackTrace(sb, r.arg.exception, DoJdbc.conf.exception_alert_stack_size);
        }
        e.message = sb.toString();
        DataPackSender.send(e);
    }
}

