/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.exception;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.data.DataPackSender;
import whatap.agent.trace.exception.ExceptionAlert;
import whatap.agent.trace.exception.UrlEx;
import whatap.lang.pack.EventPack;
import whatap.notice.WHATAP_ERROR;
import whatap.util.IntSet;
import whatap.util.LinkedMap;
import whatap.util.StringUtil;

public class DoHttpCall {
    static LinkedMap<UrlEx, ExceptionAlert.TIMECNT> timeMap = new LinkedMap<UrlEx, ExceptionAlert.TIMECNT>(){

        @Override
        protected ExceptionAlert.TIMECNT create(UrlEx key) {
            return new ExceptionAlert.TIMECNT();
        }
    }.setMax(1000);
    static Configure conf = Configure.getInstance();

    static void resetIgnoreRecord(long base) {
        Enumeration<ExceptionAlert.TIMECNT> en = timeMap.values();
        while (en.hasMoreElements()) {
            ExceptionAlert.TIMECNT t = en.nextElement();
            if (t.last_alert_time >= base || t.last_data_time >= base) continue;
            t.ignored = 0;
        }
    }

    public static void process(ExceptionAlert.Item r) {
        if (r.ctx == null || r.arg == null || r.arg.exception == null) {
            return;
        }
        if (r.httpc == null || r.httpc.url == null) {
            return;
        }
        if (DoHttpCall.conf.httpc_status_alert_ignore.contains(r.httpc.status)) {
            return;
        }
        if (DoHttpCall.ignoreHttpcStatusAlert(r.httpc.status, r.httpc.urlhash)) {
            return;
        }
        if (DoHttpCall.conf.httpc_status_error_mode == 2 && r.httpc.status == 0 && r.arg.exception != WHATAP_ERROR.slow_httpc) {
            return;
        }
        String className = r.arg.exception.getClass().getName();
        if (className.startsWith("whatap.")) {
            className.substring(className.lastIndexOf(".") + 1);
        }
        long now = System.currentTimeMillis();
        ExceptionAlert.TIMECNT tm = timeMap.intern(new UrlEx(r.httpc.url, className));
        if (now - tm.last_alert_time < DoHttpCall.conf.exception_alert_silent_time) {
            tm.last_data_time = now;
            ++tm.ignored;
            return;
        }
        tm.last_alert_time = now;
        EventPack e = new EventPack();
        e.title = "HTTPCALL_EXCEPTION";
        e.level = (byte)20;
        e.status = 1;
        e.attr.put("hash", Integer.toString(r.httpc.urlhash));
        e.attr.put("host", Integer.toString(r.httpc.hosthash));
        e.attr.put("port", Integer.toString(r.httpc.port));
        StringBuffer sb = new StringBuffer();
        if (r.arg.exception != WHATAP_ERROR.httpc_error && StringUtil.isNotEmpty(r.arg.message)) {
            sb.append(r.arg.message).append("\n");
        }
        if (r.ctx.origin_url != null) {
            e.attr.put("url", r.ctx.origin_url);
        } else {
            e.attr.put("url", r.ctx.service_name);
        }
        e.attr.put("txid", Long.toString(r.ctx.txid));
        e.attr.put("httpc_url", r.httpc.url);
        e.attr.put("class", className);
        sb.append("oname: ").append(SecurityMaster.getInstance().ONAME).append("\n");
        if (r.ctx.origin_url != null) {
            sb.append("url: ").append(r.ctx.origin_url).append("\n");
        } else {
            sb.append("url: ").append(r.ctx.service_name).append("\n");
        }
        sb.append("txid: ").append(r.ctx.txid).append("\n");
        sb.append("httpc_url: ").append(r.httpc.url).append("\n");
        if (r.httpc.status > 0) {
            sb.append("status: ").append(r.httpc.status).append("\n");
        }
        if (StringUtil.isNotEmpty(r.httpc.status_reason)) {
            sb.append("reason: ").append(r.httpc.status_reason);
        }
        if (tm.ignored > 0) {
            e.attr.put("ignored", Integer.toString(tm.ignored));
            sb.append("ignored: ").append(tm.ignored).append("\n");
            tm.ignored = 0;
        }
        e.message = sb.toString();
        DataPackSender.send(e);
    }

    private static boolean ignoreHttpcStatusAlert(int status, int url) {
        if (!DoHttpCall.conf._has_httpc_status_url_alert_ignore_set) {
            return false;
        }
        IntSet set = DoHttpCall.conf.httpc_status_url_alert_ignore_set.get(status);
        if (set == null) {
            return false;
        }
        boolean result = set.contains(url);
        return result;
    }
}

