/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfTrace;
import whatap.agent.trace.IProfileCollector;
import whatap.lang.step.Step;

public class ProfileNormalCollector
implements IProfileCollector {
    protected Step[] buffer = new Step[ConfTrace.trace_step_max_count];
    protected int NORMAL_LEN = ConfTrace.trace_step_normal_count;
    protected int HEAVY_LEN = ConfTrace.trace_step_heavy_count;
    protected int heavy_time = ConfTrace.trace_step_heavy_time;
    public int position = 0;
    public int parent_index = -1;

    public boolean hasStep() {
        return this.position > 0;
    }

    public synchronized void push(Step step) {
        if (this.position < this.NORMAL_LEN) {
            step.index = this.position;
            step.parent = this.parent_index;
            this.parent_index = this.position;
            this.buffer[this.position] = step;
            ++this.position;
        } else {
            step.drop = true;
        }
    }

    public synchronized void add(Step step) {
        if (this.position < this.NORMAL_LEN) {
            step.index = this.position;
            step.parent = this.parent_index;
            this.buffer[this.position] = step;
            ++this.position;
        }
    }

    public void justAdd(Step step) {
        if (this.position < this.NORMAL_LEN) {
            this.buffer[this.position] = step;
            ++this.position;
        }
    }

    public synchronized void append(Step step) {
        if (this.position < this.NORMAL_LEN) {
            if (step.parent >= 0) {
                step.parent += this.position - step.index;
            }
            step.index = this.position;
            this.buffer[this.position] = step;
            ++this.position;
        }
    }

    public synchronized void addTail(Step step) {
        if (this.position < this.buffer.length) {
            step.index = this.position;
            step.parent = this.parent_index;
            this.buffer[this.position] = step;
            ++this.position;
        }
    }

    public synchronized void pop(Step step) {
        if (step.drop) {
            if (this.position < this.HEAVY_LEN && step.getElapsed() >= this.heavy_time) {
                step.index = this.position;
                step.parent = this.parent_index;
                this.buffer[this.position] = step;
                ++this.position;
            }
        } else {
            this.parent_index = step.parent;
        }
    }

    public synchronized Step[] getLastSteps(int n) {
        int cnt = this.position > n ? n : this.position;
        Step[] buff = new Step[cnt];
        int x = this.position - cnt;
        for (int i = 0; i < cnt; ++i) {
            buff[i] = this.buffer[x + i];
        }
        return buff;
    }

    public synchronized Step[] getSteps() {
        if (this.position >= this.buffer.length) {
            return this.buffer;
        }
        Step[] buff = new Step[this.position];
        if (this.position > 0) {
            System.arraycopy(this.buffer, 0, buff, 0, this.position);
        }
        return buff;
    }

    public byte[] toBytes() {
        return Step.toBytes(this.getSteps());
    }

    public Step[] getStep4Error() {
        return this.getLastSteps(5);
    }

    public boolean isReal() {
        return true;
    }

    public synchronized void append(Step[] steps) {
        if (steps == null) {
            return;
        }
        for (int i = 0; i < steps.length; ++i) {
            this.append(steps[i]);
        }
    }

    public synchronized void append(int parentOffsetTime, Step[] steps) {
        if (steps == null) {
            return;
        }
        for (int i = 0; i < steps.length; ++i) {
            steps[i].start_time += parentOffsetTime;
            this.append(steps[i]);
        }
    }

    public int getSplitCount() {
        return 0;
    }

    public int length() {
        return this.position;
    }
}

