/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataTextAgent;
import whatap.lang.conf.ConfObserver;
import whatap.lang.step.HttpcStepX;
import whatap.lang.step.MethodStepX;
import whatap.lang.step.SqlStepX;
import whatap.util.IntLinkedSet;

public class BuildPos {
    public static int httpc_stack_count;
    public static int sql_stack_count;
    public static int method_stack_count;
    private static IntLinkedSet sqlPos;
    private static IntLinkedSet httpcPos;
    private static IntLinkedSet methodPos;
    private static IntLinkedSet sqlPosFail;
    private static IntLinkedSet httpcPosFail;
    private static IntLinkedSet methodPosFail;
    private static int position_sql_hash;
    private static int position_httpc_hash;
    private static int position_method_hash;

    public static void profileSqlPos(SqlStepX step, String sql) {
        if (sql == null || sql_stack_count > ConfTrace.trace_position_count) {
            return;
        }
        if (sqlPosFail.contains(step.hash)) {
            return;
        }
        if (sqlPos.contains(step.hash)) {
            ++sql_stack_count;
            step.stack = BuildPos.buildPosStack();
            return;
        }
        String[] words = ConfTrace.trace_position_sql;
        for (int x = 0; x < words.length; ++x) {
            if (sql.indexOf(words[x]) < 0) continue;
            ++sql_stack_count;
            step.stack = BuildPos.buildPosStack();
            sqlPos.put(step.hash);
            return;
        }
        sqlPosFail.put(step.hash);
    }

    public static void profileHttpcPos(HttpcStepX step, String httpc) {
        if (httpc == null || httpc_stack_count > ConfTrace.trace_position_count) {
            return;
        }
        if (httpcPosFail.contains(step.url)) {
            return;
        }
        if (httpcPos.contains(step.url)) {
            ++httpc_stack_count;
            step.stack = BuildPos.buildPosStack();
            return;
        }
        String[] words = ConfTrace.trace_position_httpc;
        for (int x = 0; x < words.length; ++x) {
            if (httpc.indexOf(words[x]) < 0) continue;
            ++httpc_stack_count;
            step.stack = BuildPos.buildPosStack();
            httpcPos.put(step.url);
            return;
        }
        httpcPosFail.put(step.url);
    }

    public static void profileMethodPos(MethodStepX step, String methodName) {
        if (methodName == null || method_stack_count > ConfTrace.trace_position_count) {
            return;
        }
        if (methodPosFail.contains(step.hash)) {
            return;
        }
        if (methodPos.contains(step.hash)) {
            ++method_stack_count;
            step.stack = BuildPos.buildPosStack();
            return;
        }
        String[] words = ConfTrace.trace_position_method;
        for (int x = 0; x < words.length; ++x) {
            if (methodName.indexOf(words[x]) < 0) continue;
            ++method_stack_count;
            step.stack = BuildPos.buildPosStack();
            methodPos.put(step.hash);
            return;
        }
        methodPosFail.put(step.hash);
    }

    private static int[] buildPosStack() {
        int skip = 3;
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        int max = Math.min(se.length - skip, ConfTrace.trace_position_depth);
        int[] stack = new int[max];
        int i = 0;
        int j = skip;
        while (i < max) {
            stack[i] = se[j].hashCode();
            DataTextAgent.STACK.add(stack[i], se[j]);
            ++i;
            ++j;
        }
        return stack;
    }

    static {
        sqlPos = new IntLinkedSet().setMax(1000);
        httpcPos = new IntLinkedSet().setMax(1000);
        methodPos = new IntLinkedSet().setMax(1000);
        sqlPosFail = new IntLinkedSet().setMax(1000);
        httpcPosFail = new IntLinkedSet().setMax(1000);
        methodPosFail = new IntLinkedSet().setMax(1000);
        position_sql_hash = 0;
        position_httpc_hash = 0;
        position_method_hash = 0;
        position_httpc_hash = ConfTrace._trace_position_httpc_hash;
        position_sql_hash = ConfTrace._trace_position_sql_hash;
        position_method_hash = ConfTrace._trace_position_method_hash;
        ConfObserver.add("BuildPos", new Runnable(){

            public void run() {
                if (ConfTrace._trace_position_httpc_hash != position_httpc_hash) {
                    position_httpc_hash = ConfTrace._trace_position_httpc_hash;
                    httpcPos.clear();
                    httpc_stack_count = 0;
                }
                if (ConfTrace._trace_position_sql_hash != position_sql_hash) {
                    position_sql_hash = ConfTrace._trace_position_sql_hash;
                    sqlPos.clear();
                    sql_stack_count = 0;
                }
                if (ConfTrace._trace_position_method_hash != position_method_hash) {
                    position_method_hash = ConfTrace._trace_position_method_hash;
                    methodPos.clear();
                    method_stack_count = 0;
                }
            }
        });
    }
}

