/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.ZipPackThread;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.StatUserAgentPack1;
import whatap.util.IntIntLinkedMap;

public class StatUserAgent {
    private static StatUserAgent instance;
    private final int TABLE_MAX_SIZE = 500;
    private final IntIntLinkedMap table = new IntIntLinkedMap(501, 1.0f).setMax(500);
    public int userAgentMaxSize = 0;
    Configure conf = Configure.getInstance();

    public static synchronized StatUserAgent getInstance() {
        if (instance == null) {
            instance = new StatUserAgent();
        }
        return instance;
    }

    public StatUserAgent() {
        this.table.setMax(ConfStat.stat_useragent_max_count);
        ConfObserver.add("StatUserAgent", new Runnable(){

            public void run() {
                StatUserAgent.this.table.setMax(ConfStat.stat_useragent_max_count);
            }
        });
    }

    public void incUserAgent(int userAgent) {
        if (userAgent == 0) {
            return;
        }
        this.table.addNoOver(userAgent, 1);
    }

    protected void send(long now) {
        if (this.table.size() == 0) {
            return;
        }
        try {
            StatUserAgentPack1 p;
            if (this.userAgentMaxSize < this.table.size()) {
                this.userAgentMaxSize = this.table.size();
            }
            if (ConfStat.stat_1m_enabled) {
                p = new StatUserAgentPack1(4610);
                p.dataStartTime = now - 60000L;
            } else {
                p = new StatUserAgentPack1();
            }
            Enumeration<IntIntLinkedMap.IntIntLinkedEntry> en = this.table.entries();
            while (en.hasMoreElements()) {
                IntIntLinkedMap.IntIntLinkedEntry e = en.nextElement();
                p.userAgents.put(e.getKey(), e.getValue());
            }
            p.time = now;
            this.table.clear();
            if (ConfStat.stat_zip_enabled) {
                ZipPackThread.getInstance().add(p);
            } else {
                DataPackSender.send(p);
            }
        }
        catch (Exception e) {
            Logger.println("A200", 10, e.toString());
        }
    }

    protected void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }
}

