/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.ZipPackThread;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.StatGeneralPack;
import whatap.lang.pack.TimeCount;
import whatap.util.BitUtil;
import whatap.util.IntList;
import whatap.util.LongKeyLinkedMap;
import whatap.util.LongList;

public class StatTranxStatus {
    private static StatTranxStatus instance;
    private final int TABLE_MAX_SIZE = 10000;
    private LongKeyLinkedMap<TimeCount> table1 = new LongKeyLinkedMap<TimeCount>(10001, 1.0f){

        @Override
        protected TimeCount create(long key) {
            return new TimeCount();
        }
    }.setMax(10000);

    public static synchronized StatTranxStatus getInstance() {
        if (instance == null) {
            instance = new StatTranxStatus();
        }
        return instance;
    }

    public StatTranxStatus() {
        this.table1.setMax(ConfStat.stat_status_url_max_count);
        ConfObserver.add("StatTranxStatus", new Runnable(){

            public void run() {
                StatTranxStatus.this.table1.setMax(ConfStat.stat_status_url_max_count);
            }
        });
    }

    public TimeCount getService(int status, int urlhash) {
        long key = BitUtil.composite(status, urlhash);
        if (this.table1.size() < ConfStat.stat_status_url_max_count) {
            return this.table1.intern(key);
        }
        return this.table1.get(key);
    }

    protected void send(long now) {
        if (this.table1.size() == 0) {
            return;
        }
        try {
            StatGeneralPack out;
            LongKeyLinkedMap<TimeCount> currTable = this.table1;
            int sz = Math.max(10000, ConfStat.stat_status_url_max_count);
            this.table1 = new LongKeyLinkedMap<TimeCount>(sz + 1, 1.0f){

                @Override
                protected TimeCount create(long key) {
                    return new TimeCount();
                }
            }.setMax(ConfStat.stat_status_url_max_count);
            IntList ip = new IntList(currTable.size());
            IntList status = new IntList(currTable.size());
            IntList count = new IntList(currTable.size());
            IntList error = new IntList(currTable.size());
            LongList time = new LongList(currTable.size());
            Enumeration<LongKeyLinkedMap.LongKeyLinkedEntry<TimeCount>> en = currTable.entries();
            while (en.hasMoreElements()) {
                LongKeyLinkedMap.LongKeyLinkedEntry<TimeCount> ent = en.nextElement();
                long k = ent.getKey();
                TimeCount v = ent.getValue();
                ip.add(BitUtil.getHigh(k));
                status.add(BitUtil.getLow(k));
                count.add(v.count);
                error.add(v.error);
                time.add(v.time);
            }
            if (ConfStat.stat_1m_enabled) {
                out = new StatGeneralPack(2321);
                out.dataStartTime = now - 60000L;
            } else {
                out = new StatGeneralPack();
            }
            out.put("ip", ip);
            out.put("status", status);
            out.put("count", count);
            out.put("error", error);
            out.put("time", time);
            out.id = "status-url";
            out.time = now;
            System.out.println("out=" + out);
            if (ConfStat.stat_zip_enabled) {
                ZipPackThread.getInstance().add(out);
            } else {
                DataPackSender.send(out);
            }
        }
        catch (Exception e) {
            Logger.println("STATUS-URL", 10, e.toString());
        }
    }

    protected void clear() {
        this.table1.clear();
    }

    public int size() {
        return this.table1.size();
    }
}

