/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.ZipPackThread;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.StatGeneralPack;
import whatap.lang.pack.TimeCount;
import whatap.lang.var.I2;
import whatap.util.IntList;
import whatap.util.LinkedMap;
import whatap.util.LongList;

public class StatTranxLogin {
    private static StatTranxLogin instance;
    private final int TABLE_MAX_SIZE = 7000;
    private final LinkedMap<I2, TimeCount> table = new LinkedMap<I2, TimeCount>(7001, 1.0f){

        @Override
        protected TimeCount create(I2 key) {
            if (this.isFull()) {
                return null;
            }
            return new TimeCount();
        }
    }.setMax(7000);

    public static synchronized StatTranxLogin getInstance() {
        if (instance == null) {
            instance = new StatTranxLogin();
        }
        return instance;
    }

    public StatTranxLogin() {
        this.table.setMax(ConfStat.stat_login_max_count);
        ConfObserver.add("StatTranxLogin", new Runnable(){

            public void run() {
                StatTranxLogin.this.table.setMax(ConfStat.stat_login_max_count);
            }
        });
    }

    public TimeCount getService(int login, int urlhash) {
        return this.table.intern(new I2(login, urlhash));
    }

    protected void send(long now) {
        if (this.table.size() == 0) {
            return;
        }
        try {
            StatGeneralPack out;
            IntList login = new IntList(this.table.size());
            IntList url = new IntList(this.table.size());
            IntList count = new IntList(this.table.size());
            IntList error = new IntList(this.table.size());
            LongList time = new LongList(this.table.size());
            Enumeration<LinkedMap.LinkedEntry<I2, TimeCount>> en = this.table.entries();
            while (en.hasMoreElements()) {
                LinkedMap.LinkedEntry<I2, TimeCount> ent = en.nextElement();
                I2 k = ent.getKey();
                TimeCount v = ent.getValue();
                login.add(k.v1);
                url.add(k.v2);
                count.add(v.count);
                error.add(v.error);
                time.add(v.time);
            }
            this.table.clear();
            if (ConfStat.stat_1m_enabled) {
                out = new StatGeneralPack(2321);
                out.dataStartTime = now - 60000L;
            } else {
                out = new StatGeneralPack();
            }
            out.put("login", login);
            out.put("url", url);
            out.put("count", count);
            out.put("error", error);
            out.put("time", time);
            out.id = "login";
            out.time = now;
            if (ConfStat.stat_zip_enabled) {
                ZipPackThread.getInstance().add(out);
            } else {
                DataPackSender.send(out);
            }
        }
        catch (Exception e) {
            Logger.println("A203", 10, e.toString());
        }
    }

    protected void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }
}

