/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import whatap.agent.Configure;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.ZipPackThread;
import whatap.lang.pack.StatRemoteIpPack;
import whatap.util.IntIntMap;

public class StatRemoteIp {
    private static StatRemoteIp instance;
    protected final int TABLE_MAX_SIZE = 70000;
    private IntIntMap table = new IntIntMap(70001, 1.0f);
    public int ipMaxSize = 0;
    Configure conf = Configure.getInstance();

    public static synchronized StatRemoteIp getInstance() {
        if (instance == null) {
            instance = new StatRemoteIp();
        }
        return instance;
    }

    public void incRemoteIp(int ip) {
        if (ip != 0) {
            if (this.table.size() < 70000) {
                this.table.add(ip, 1);
            } else {
                this.table.addIfExist(ip, 1);
            }
        }
    }

    protected void send(long now) {
        StatRemoteIpPack p;
        if (this.table.size() == 0) {
            return;
        }
        if (this.ipMaxSize < this.table.size()) {
            this.ipMaxSize = this.table.size();
        }
        if (ConfStat.stat_1m_enabled) {
            p = new StatRemoteIpPack(4353);
            p.dataStartTime = now - 60000L;
        } else {
            p = new StatRemoteIpPack();
        }
        p.time = now;
        p.iptable.putAll(this.table);
        this.table.clear();
        if (ConfStat.stat_zip_enabled) {
            ZipPackThread.getInstance().add(p);
        } else {
            DataPackSender.send(p);
        }
    }

    public void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }
}

