/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.util.Random;
import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.logo.Logo;
import whatap.agent.net.TcpRequestMgr;
import whatap.agent.net.TcpSession;
import whatap.lang.pack.TagCountPack;
import whatap.util.AnsiPrint;
import whatap.util.DateUtil;
import whatap.util.IPUtil;
import whatap.util.JarUtil;
import whatap.util.KeyGen;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class TagCountTest {
    static Random r = new Random();

    public static void main(String[] args) {
        System.setProperty("whatap.disabled", "true");
        if (System.getProperty("whatap.home") == null) {
            String home = JarUtil.getJarLocation(TagCountTest.class);
            System.setProperty("whatap.home", home);
        }
        Configure.getInstance().waitForInit();
        Configure.TCP_SESSION_ALLOWED = true;
        SecurityMaster.getInstance();
        Logo.print();
        long seed = DateUtil.currentTime() ^ (long)SysJMX.getProcessPID() << 32;
        KeyGen.setSeed(seed);
        TcpRequestMgr.getInstance();
        TcpSession.getInstance().waitForConnection();
        while (true) {
            ThreadUtil.sleep(3000L);
            long time = DateUtil.currentTime() / 1000L * 1000L;
            TagCountTest.sendTagCount("ap-perf", time, "cpu", "mem", "net", "heap");
            TagCountTest.sendTagCount("db-pool", time, "act", "idle");
        }
    }

    private static void sendTagCount(String title, long time, String ... fields) {
        TagCountPack p = new TagCountPack();
        p.time = time;
        p.category = title;
        p.putTag("host", SysJMX.getHostName());
        p.putTag("pid", "" + SysJMX.getProcessPID());
        p.putTag("oname", SecurityMaster.getInstance().ONAME);
        p.putTag("ip", IPUtil.toString(SecurityMaster.getInstance().IP));
        int mux = 1;
        for (String f : fields) {
            p.put(f, r.nextInt(mux * 100));
            mux += 3;
        }
        SecurityMaster secuMaster = SecurityMaster.getInstance();
        p.pcode = secuMaster.PCODE;
        p.oid = 0;
        TcpRequestMgr.getInstance().add(1, true, p);
        System.out.println(AnsiPrint.yellow(DateUtil.timestamp(time) + " " + p));
    }
}

