/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.setup.ClassCV;
import whatap.agent.setup.ClassCV2;
import whatap.agent.setup.ClassInitCV;
import whatap.agent.setup.ClassPrintCV;
import whatap.org.objectweb.asm.ClassReader;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.util.AnsiPrint;
import whatap.util.FileUtil;
import whatap.util.JarUtil;
import whatap.util.ShellArg;

public class ClassFinder {
    public static boolean debug = false;
    public static boolean show_dir = false;
    public static boolean show_file = false;

    public static void main(String[] args) throws Exception {
        ShellArg sh = new ShellArg(args);
        String path = sh.get("-path");
        String jarfile = null;
        if (path == null) {
            jarfile = sh.get("-jar");
            if (jarfile == null) {
                ClassFinder.usage();
            }
            if (!new File(jarfile).exists()) {
                ClassFinder.usage();
            }
        }
        show_dir = sh.hasKey("-show:dir");
        show_file = sh.hasKey("-show:file");
        debug = sh.hasKey("-debug");
        String mode = sh.get("-m");
        String classMethod = sh.get2("-m");
        if (mode == null || classMethod == null) {
            ClassFinder.usage();
        }
        if (path != null) {
            File[] sub;
            for (File f : sub = new File(path).listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                System.out.println("finding " + AnsiPrint.cyan(f.getAbsoluteFile()));
                ClassFinder.process(f, mode, classMethod, "    ");
            }
        } else {
            ClassFinder.process(new File(jarfile), mode, classMethod, "    ");
        }
    }

    private static void process(File jarfile, String mode, String classMethod, String space) throws IOException {
        JarFile inFile = new JarFile(jarfile);
        Enumeration<JarEntry> en = inFile.entries();
        while (en.hasMoreElements()) {
            byte[] classBytes;
            InputStream in;
            JarEntry ent = en.nextElement();
            if ("class".equals(mode)) {
                try {
                    if (ent.getName().indexOf(classMethod) < 0) continue;
                    System.out.println(space + AnsiPrint.green(ent.getName()) + " at " + jarfile.getName());
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                continue;
            }
            if ("mf".equals(mode)) {
                String nm = ent.getName().toLowerCase();
                if (!nm.endsWith(".mf")) continue;
                InputStream in2 = inFile.getInputStream(ent);
                byte[] classBytes2 = FileUtil.readAll(in2);
                in2.close();
                String x = new String(classBytes2);
                if (x.indexOf(classMethod) < 0) continue;
                System.out.println(space + AnsiPrint.green("found " + ent.getName() + " at " + jarfile.getName()));
                continue;
            }
            if (!ent.getName().endsWith(".class")) {
                if (ent.getName().endsWith(".jar")) {
                    in = inFile.getInputStream(ent);
                    classBytes = FileUtil.readAll(in);
                    in.close();
                    File f = File.createTempFile(ent.getName().replace('/', '.'), "jar");
                    FileUtil.save(f, classBytes);
                    System.out.println(space + AnsiPrint.green("searching " + ent.getName()));
                    ClassFinder.process(f, mode, classMethod, space + "\t");
                    continue;
                }
                if (show_dir && ent.getName().endsWith("/")) {
                    System.out.println(ent.getName());
                }
                if (!show_file || ent.getName().endsWith("/")) continue;
                System.out.println(ent.getName());
                continue;
            }
            if (debug) {
                System.out.println(space + ClassFinder.c(ent.getName()));
            }
            in = inFile.getInputStream(ent);
            classBytes = FileUtil.readAll(in);
            in.close();
            if (classBytes == null || classBytes.length == 0) {
                System.err.println(ent.getName() + " has no body");
                continue;
            }
            if ("caller".equals(mode) || "caller:class".equals(mode)) {
                ClassFinder.f_caller(mode, classBytes, classMethod, space);
                continue;
            }
            if ("interface".equals(mode)) {
                try {
                    ClassFinder.f_interface(classBytes, classMethod, space);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                continue;
            }
            if ("super".equals(mode)) {
                try {
                    ClassFinder.f_super(classBytes, classMethod, space);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                continue;
            }
            if ("print:init".equals(mode)) {
                try {
                    ClassFinder.f_init(classBytes, classMethod, space);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                continue;
            }
            if ("print".equals(mode)) {
                try {
                    ClassFinder.f_print(classBytes, classMethod, space);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                continue;
            }
            ClassFinder.usage();
        }
        inFile.close();
    }

    private static void usage() {
        System.out.println("java -cp " + JarUtil.getJarFileName(ClassFinder.class) + " " + ClassFinder.class.getName() + "  -jar [jarfile] -m [mode] [class/method]");
        System.out.println("             mode : caller, class, caller:class, interface, super, print:init, print");
        System.exit(1);
    }

    public static String c(String name) {
        return name.replace('/', '.');
    }

    private static void f_super(byte[] classBytes, final String class1, final String space) {
        ClassReader cr = new ClassReader(classBytes);
        cr.accept(new ClassVisitor(IASM.API){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                if (debug) {
                    System.out.println(space + "\tdebug " + name + " extends " + superName);
                }
                name = ClassFinder.c(name);
                if ((superName = ClassFinder.c(superName)).indexOf(class1) >= 0) {
                    String pre = AsmUtil.getClassAccessString(access);
                    System.out.println(space + pre + AnsiPrint.yellow(name) + " extends " + superName);
                }
            }
        }, 0);
    }

    private static void f_interface(byte[] classBytes, final String interface1, final String space) {
        ClassReader cr = new ClassReader(classBytes);
        cr.accept(new ClassVisitor(IASM.API){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                int i;
                super.visit(version, access, name, signature, superName, interfaces);
                name = ClassFinder.c(name);
                for (i = 0; i < interfaces.length; ++i) {
                    interfaces[i] = ClassFinder.c(interfaces[i]);
                }
                if (debug) {
                    System.out.println(space + "\tdebug " + name + " implements " + AsmUtil.infToString(interfaces));
                }
                for (i = 0; i < interfaces.length; ++i) {
                    if (interfaces[i].indexOf(interface1) < 0) continue;
                    String pre = AsmUtil.getClassAccessString(access);
                    String impl = AsmUtil.isInterface(access) ? " extends " : " implements ";
                    System.out.println(space + pre + AnsiPrint.green(name) + impl + AsmUtil.infToString(interfaces));
                    return;
                }
            }
        }, 0);
    }

    private static void f_caller(String mode, byte[] classBytes, String classMethod, String space) {
        ClassCV.classOnly = "caller:class".equals(mode);
        ClassCV.classDesc.version = ClassFinder.findClassVersion(classBytes);
        ClassCV.caller.push(classMethod);
        ClassCV.spacing.push(space);
        ClassReader cr = new ClassReader(classBytes);
        try {
            cr.accept(new ClassCV(), 8);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        ClassCV.caller.pop();
        ClassCV.spacing.pop();
    }

    private static void f_method(String mode, byte[] classBytes, String classMethod, String space) {
        ClassCV2.classOnly = "caller:class".equals(mode);
        ClassCV2.classDesc.version = ClassFinder.findClassVersion(classBytes);
        ClassReader cr = new ClassReader(classBytes);
        cr.accept(new ClassCV2(), 8);
    }

    private static void f_init(final byte[] classBytes, final String class1, String space) {
        ClassReader cr = new ClassReader(classBytes);
        cr.accept(new ClassVisitor(IASM.API){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if ((name = ClassFinder.c(name)).indexOf(class1) >= 0) {
                    ClassCV.classDesc.version = version;
                    ClassReader cr = new ClassReader(classBytes);
                    cr.accept(new ClassInitCV(), 8);
                }
            }
        }, 0);
    }

    private static void f_print(final byte[] classBytes, final String class1, String space) {
        ClassReader cr = new ClassReader(classBytes);
        cr.accept(new ClassVisitor(IASM.API){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if ((name = ClassFinder.c(name)).indexOf(class1) >= 0) {
                    ClassCV.classDesc.version = version;
                    ClassReader cr = new ClassReader(classBytes);
                    cr.accept(new ClassPrintCV(), 8);
                }
            }
        }, 0);
    }

    private static int findClassVersion(byte[] classBytes) {
        final ClassDesc classDesc = new ClassDesc();
        ClassReader cr = new ClassReader(classBytes);
        cr.accept(new ClassVisitor(IASM.API){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                classDesc.version = version;
            }
        }, 0);
        return classDesc.version;
    }
}

