/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.proxy;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import whatap.agent.Logger;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.proxy.ISigar;
import whatap.agent.proxy.LoaderManager;
import whatap.sigar.Cpu;
import whatap.sigar.CpuPerc;
import whatap.sigar.FileSystem;
import whatap.sigar.FileSystemUsage;
import whatap.sigar.Mem;
import whatap.sigar.NetInterfaceConfig;
import whatap.sigar.NetInterfaceStat;
import whatap.sigar.NetStat;
import whatap.sigar.ProcCpu;
import whatap.sigar.ProcMem;
import whatap.sigar.Swap;
import whatap.util.FileUtil;
import whatap.util.JarUtil;
import whatap.util.StopWatch;
import whatap.util.SystemUtil;

public class SigarFactory {
    private static final String SIGAR = "whatap.xtra.sigar.SigarMain";
    public static final ISigar dummy = new ISigar(){

        public boolean isOk() {
            return false;
        }

        public String getError() {
            return null;
        }

        public long getPid() {
            return 0L;
        }

        public long getProcFd(long pid) {
            return 0L;
        }

        public ProcCpu getProcCpu(long pid) {
            return new ProcCpu();
        }

        public ProcMem getProcMem(long pid) {
            return new ProcMem();
        }

        public CpuPerc getCpuPerc() {
            return new CpuPerc();
        }

        public CpuPerc[] getCpuPercList() {
            return new CpuPerc[0];
        }

        public Cpu getCpu() {
            return new Cpu();
        }

        public Cpu[] getCpuList() {
            return new Cpu[0];
        }

        public Mem getMem() {
            return new Mem();
        }

        public NetStat getNetStat() {
            return new NetStat();
        }

        public Swap getSwap() {
            return new Swap();
        }

        public FileSystem[] getFileSystemList() {
            return new FileSystem[0];
        }

        public FileSystemUsage getFileSystemUsage(String dir) {
            return new FileSystemUsage();
        }

        public String[] getNetInterfaceList() {
            return new String[0];
        }

        public NetInterfaceConfig getNetInterfaceConfig(String name) {
            return new NetInterfaceConfig();
        }

        public NetInterfaceStat getNetInterfaceStat(String name) {
            return new NetInterfaceStat();
        }
    };

    public static ISigar create() {
        if (!ConfSysMon.sigar_enabled) {
            return dummy;
        }
        try {
            SigarFactory.deployLib1("lib3");
            ClassLoader loader = LoaderManager.getSigarLoader("lib3");
            if (loader == null) {
                return dummy;
            }
            Class<?> c = Class.forName(SIGAR, true, loader);
            return (ISigar)c.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.println("A141", 10, "fail to create", e);
            return dummy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deployLib1(String libname) {
        StopWatch sw = new StopWatch();
        String thisJarPath = JarUtil.getThisJarName(SigarFactory.class);
        String location = new File(thisJarPath).getParent();
        File base = new File(location, libname);
        if (base.exists()) {
            Logger.println("SysCpu", "[" + libname + "] is already installed");
            return;
        }
        if (!SystemUtil.IS_JAVA_1_5) {
            try {
                base.setWritable(true);
                base.setExecutable(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        base.mkdirs();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(thisJarPath);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry ent = en.nextElement();
                if (!ent.getName().startsWith(libname) || ent.isDirectory()) continue;
                String justFileName = ent.getName().substring(ent.getName().lastIndexOf("/") + 1);
                InputStream input = null;
                try {
                    input = jarFile.getInputStream(ent);
                    byte[] b = FileUtil.readAll(input);
                    FileUtil.save(new File(base, justFileName), b);
                }
                finally {
                    FileUtil.close(input);
                }
            }
            FileUtil.save(new File(base, libname + ".done"), new byte[0]);
        }
        catch (Exception e) {
            try {
                Logger.println("SigarFactory", 10, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.close(jarFile);
                throw throwable;
            }
            FileUtil.close(jarFile);
        }
        FileUtil.close(jarFile);
        Logger.println("SigarFactory", 10, "[" + libname + "] is just installed " + sw.getTime() + " ms");
    }
}

