/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.plugin;

import whatap.lang.pack.LogSinkPack;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.FloatValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;
import whatap.util.AnsiPrint;
import whatap.util.StringUtil;

public class WrLogSinkPack {
    private LogSinkPack pack;
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[30m";
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String BLUE = "\u001b[34m";
    public static final String PURPLE = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37m";

    public WrLogSinkPack(LogSinkPack pack) {
        this.pack = pack;
    }

    public void drop() {
        this.pack.dropped = true;
    }

    public String content() {
        return this.pack.content;
    }

    public boolean isContentWord(String w) {
        if (w == null) {
            return false;
        }
        return this.pack.content.indexOf(w) >= 0;
    }

    public String category() {
        return this.pack.category;
    }

    public boolean hasTag(String key) {
        return this.pack.tags.containsKey(key);
    }

    public String tag(String key) {
        return this.pack.tags.getText(key);
    }

    public void tag(String key, String value) {
        if (value != null) {
            this.pack.tags.put(key, value);
        }
    }

    public void field(String key, String value) {
        this.field(key, new TextValue(value));
    }

    public void field(String key, long value) {
        this.field(key, new DecimalValue(value));
    }

    public void field(String key, float value) {
        this.field(key, new FloatValue(value));
    }

    public void field(String key, Value value) {
        if (this.pack.fields == null) {
            this.pack.fields = new MapValue();
        }
        this.pack.fields.put(key, value);
    }

    public LogSinkPack inner() {
        return this.pack;
    }

    public void ansi(String color) {
        this.pack.content = color + this.pack.content + RESET;
    }

    public void removeAnsiFromContent() {
        if (StringUtil.isNotEmpty(this.pack.content)) {
            this.pack.content = AnsiPrint.erase(this.pack.content);
        }
    }
}

