/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.plugin;

import java.net.HttpURLConnection;
import whatap.agent.Logger;
import whatap.agent.plugin.Wrapper;
import whatap.agent.proxy.IHttpClient;
import whatap.util.ObjectUtil;

public class WrHttpCRequest
extends Wrapper {
    protected static Class[] arg_c_ss = new Class[]{String.class, String.class};
    private Object reqHost;
    private Object reqObject;
    private HttpURLConnection urlCon;
    private IHttpClient httpclient;
    private boolean enabled = true;
    private Throwable _error;

    public WrHttpCRequest(HttpURLConnection urlCon) {
        this.urlCon = urlCon;
    }

    public WrHttpCRequest(IHttpClient httpclient, Object host, Object req) {
        this.httpclient = httpclient;
        this.reqHost = host;
        this.reqObject = req;
    }

    public void header(Object key, Object value) {
        if (!this.enabled || key == null || value == null) {
            return;
        }
        try {
            if (this.urlCon != null) {
                this.urlCon.setRequestProperty(this.toString(key), this.toString(value));
                return;
            }
            if (this.httpclient != null) {
                this.httpclient.addHeader(this.reqObject, this.toString(key), this.toString(value));
                return;
            }
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A190", 10, e);
        }
    }

    public String url() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.urlCon != null) {
                return this.urlCon.getURL().getPath();
            }
            if (this.httpclient != null) {
                return this.httpclient.getURI(this.reqHost);
            }
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
        }
        return null;
    }

    public String host() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.urlCon != null) {
                return this.urlCon.getURL().getHost();
            }
            if (this.httpclient != null) {
                return this.httpclient.getHost(this.reqHost);
            }
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
        }
        return null;
    }

    public int port() {
        if (!this.enabled) {
            return 0;
        }
        try {
            if (this.urlCon != null) {
                return this.urlCon.getURL().getPort();
            }
            if (this.httpclient != null) {
                return this.httpclient.getPort(this.reqHost);
            }
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
        }
        return 0;
    }

    private String toString(Object value) {
        String s = ObjectUtil.toString(value);
        if (s.length() > 80) {
            return s.substring(0, 80);
        }
        return s;
    }

    public Object inner() {
        return this.reqObject;
    }

    public boolean isOk() {
        return this.enabled;
    }

    public Throwable error() {
        return this._error;
    }
}

