/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.plugin;

import java.lang.ref.WeakReference;
import whatap.agent.Configure;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.counter.task.custom.CustomTaskLoader;
import whatap.agent.plugin.PluginActionScript;
import whatap.agent.plugin.PluginAppServiceEnd;
import whatap.agent.plugin.PluginAppServiceStart;
import whatap.agent.plugin.PluginCunstomPool;
import whatap.agent.plugin.PluginExtraCounter;
import whatap.agent.plugin.PluginHttpCallEnd;
import whatap.agent.plugin.PluginHttpCallStart;
import whatap.agent.plugin.PluginHttpServiceEnd;
import whatap.agent.plugin.PluginHttpServiceStart;
import whatap.agent.plugin.PluginLoader;
import whatap.agent.plugin.PluginLogSink;
import whatap.agent.plugin.PluginRemoteCall;
import whatap.agent.plugin.PluginShellPerf;
import whatap.agent.plugin.PluginTraceHelperEnd;
import whatap.agent.plugin.PluginTraceHelperStart;
import whatap.agent.plugin.x.ActionScript;
import whatap.agent.plugin.x.AppServiceEnd;
import whatap.agent.plugin.x.AppServiceStart;
import whatap.agent.plugin.x.CustomPool;
import whatap.agent.plugin.x.ExtraCounter;
import whatap.agent.plugin.x.HttpCallEnd;
import whatap.agent.plugin.x.HttpCallStart;
import whatap.agent.plugin.x.HttpServiceEnd;
import whatap.agent.plugin.x.HttpServiceStart;
import whatap.agent.plugin.x.LogSink;
import whatap.agent.plugin.x.RemoteCall;
import whatap.agent.plugin.x.ShellPerf;
import whatap.agent.plugin.x.TraceHelperEnd;
import whatap.agent.plugin.x.TraceHelperStart;
import whatap.lang.ref.BOOLEAN;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class PluginLoadThread
extends Thread {
    private static PluginLoadThread instance;
    private boolean ok = true;
    private static WeakReference<ClassLoader> parentLoader;
    private PluginLoader appServiceStart = new PluginLoader(AppServiceStart.class).setParamName(new String[]{"$ctx", "$point"});
    private PluginLoader appServiceEnd = new PluginLoader(AppServiceEnd.class).setParamName(new String[]{"$ctx", "$rtn"});
    private PluginLoader httpServiceStart = new PluginLoader(HttpServiceStart.class).setParamName(new String[]{"$ctx", "$req", "$res"});
    private PluginLoader httpServiceEnd = new PluginLoader(HttpServiceEnd.class).setParamName(new String[]{"$ctx", "$req", "$res"});
    private PluginLoader httpCallStart = new PluginLoader(HttpCallStart.class).setParamName(new String[]{"$ctx", "$req"});
    private PluginLoader httpCallEnd = new PluginLoader(HttpCallEnd.class).setParamName(new String[]{"$ctx", "$resp"});
    private PluginLoader extraCounter = new PluginLoader(ExtraCounter.class).setParamName(new String[]{"$pack"});
    private PluginLoader traceHelperStart = new PluginLoader(TraceHelperStart.class).setParamName(new String[]{"$ctx", "$point"});
    private PluginLoader traceHelperEnd = new PluginLoader(TraceHelperEnd.class).setParamName(new String[]{"$ctx", "$point"});
    private PluginLoader remoteCall = new PluginLoader(RemoteCall.class).setParamName(new String[]{"$ctx", "$point"});
    private PluginLoader dbPool = new PluginLoader(CustomPool.class).setParamName(new String[]{"$id", "$pool", "$result"});
    private PluginLoader actionScript = new PluginLoader(ActionScript.class).setParamName(new String[]{"$id", "$value"});
    private PluginLoader shellPerf = new PluginLoader(ShellPerf.class).setParamName(new String[]{"$line"});
    private PluginLoader logSink = new PluginLoader(LogSink.class).setParamName(new String[]{"$log"});

    public static synchronized PluginLoadThread getInstance() {
        if (instance == null) {
            instance = new PluginLoadThread();
            instance.setName("PluginLoadThread");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void run() {
        Configure conf = Configure.getInstance();
        if (conf.plugin_reload_wait > 0) {
            ThreadUtil.sleep(conf.plugin_reload_wait);
        }
        if (JavaAgent.instrumentation == null) {
            Logger.println("PluginLoaderManager", "Warning JavaAgent.instrumentation is null, can not load plugins");
            return;
        }
        while (this.ok) {
            try {
                ClassLoader loader = null;
                if (JavaAgent.instrumentation != null) {
                    loader = this.findParentClassLoader(conf.plugin_reload_interval);
                }
                this.createPluginWithClassLoader(loader);
            }
            catch (NullPointerException t) {
                Logger.println("PluginLoaderManager", 10, t.toString(), t);
            }
            catch (Throwable t) {
                Logger.println("PluginLoaderManager", 10, t.toString());
            }
            ThreadUtil.sleep(conf.plugin_reload_interval);
        }
    }

    private void createPluginWithClassLoader(ClassLoader loader) {
        BOOLEAN md = new BOOLEAN();
        PluginAppServiceStart.plugIn = (AppServiceStart)this.appServiceStart.create(loader, md);
        PluginAppServiceEnd.plugIn = (AppServiceEnd)this.appServiceEnd.create(loader, md);
        PluginHttpServiceStart.plugIn = (HttpServiceStart)this.httpServiceStart.create(loader, md);
        PluginHttpServiceEnd.plugIn = (HttpServiceEnd)this.httpServiceEnd.create(loader, md);
        PluginHttpCallStart.plugIn = (HttpCallStart)this.httpCallStart.create(loader, md);
        PluginHttpCallEnd.plugIn = (HttpCallEnd)this.httpCallEnd.create(loader, md);
        PluginExtraCounter.plugIn = (ExtraCounter)this.extraCounter.create(loader, md);
        PluginTraceHelperStart.plugIn = (TraceHelperStart)this.traceHelperStart.create(loader, md);
        PluginTraceHelperEnd.plugIn = (TraceHelperEnd)this.traceHelperEnd.create(loader, md);
        PluginRemoteCall.plugIn = (RemoteCall)this.remoteCall.create(loader, md);
        PluginCunstomPool.plugIn = (CustomPool)this.dbPool.create(loader, md);
        PluginActionScript.plugIn = (ActionScript)this.actionScript.create(loader, md);
        PluginShellPerf.plugIn = (ShellPerf)this.shellPerf.create(loader, md);
        PluginLogSink.plugIn = (LogSink)this.logSink.create(loader, md);
        CustomTaskLoader.load(loader);
    }

    private ClassLoader findParentClassLoader(long interval) {
        if (parentLoader != null && parentLoader.get() != null) {
            return (ClassLoader)parentLoader.get();
        }
        String parentClassPrefix = Configure.getInstance().plugin_parent_class_prefix;
        boolean hasPclass = StringUtil.isNotEmpty(parentClassPrefix);
        Class[] klass = JavaAgent.instrumentation.getAllLoadedClasses();
        for (int i = 0; i < klass.length; ++i) {
            if (!hasPclass) {
                if (klass[i].getClassLoader() == null) continue;
                String className = klass[i].getName();
                if (className.startsWith("org.spring") || className.startsWith("org.apache")) {
                    parentLoader = new WeakReference<ClassLoader>(klass[i].getClassLoader());
                    ClassLoader cl = klass[i].getClassLoader();
                    Logger.println("plugin", "Classloader for plugins : [" + i + "] class=" + klass[i].getName() + " loader=" + (cl == null ? "SystemLoader" : cl.getClass().getName()));
                    return (ClassLoader)parentLoader.get();
                }
                if (klass[i].getClassLoader().getClass().getName().indexOf("App") < 0) continue;
                parentLoader = new WeakReference<ClassLoader>(klass[i].getClassLoader());
                ClassLoader cl = klass[i].getClassLoader();
                Logger.println("plugin", "Classloader for plugins : [" + i + "] class=" + klass[i].getName() + " loader=" + (cl == null ? "SystemLoader" : cl.getClass().getName()));
                return (ClassLoader)parentLoader.get();
            }
            if (!klass[i].getName().startsWith(parentClassPrefix)) continue;
            parentLoader = new WeakReference<ClassLoader>(klass[i].getClassLoader());
            ClassLoader cl = klass[i].getClassLoader();
            Logger.println("plugin", "Classloader for plugins : [" + i + "] class=" + klass[i].getName() + " loader=" + (cl == null ? "SystemLoader" : cl.getClass().getName()));
            return (ClassLoader)parentLoader.get();
        }
        Logger.println("plugin", "Classloader for plugins, try next=" + interval);
        return null;
    }

    static {
        parentLoader = null;
    }
}

