/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.pii;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import whatap.agent.pii.MatchUtil;
import whatap.lang.pack.LogSinkPack;
import whatap.util.StringUtil;

public class PiiItem {
    private boolean isContent;
    public String field;
    public String expr;
    public Pattern pattern;
    public String replace;
    public char rp_mode;

    public PiiItem(String field, String pattern, String replace) {
        this.field = field;
        this.isContent = StringUtil.isEmpty(field) || "content".equals(field);
        this.expr = pattern;
        this.pattern = Pattern.compile(pattern);
        this.replace = replace;
        if (replace.length() < 1) {
            this.replace = replace;
            this.rp_mode = '\u0000';
        } else if (replace.charAt(replace.length() - 1) == '$') {
            this.replace = replace.substring(0, replace.length() - 1);
            this.rp_mode = (char)36;
        } else if (replace.charAt(0) == '^') {
            this.replace = replace.substring(1, replace.length());
            this.rp_mode = (char)94;
        } else {
            this.replace = replace;
            this.rp_mode = '\u0000';
        }
    }

    public void mask(LogSinkPack p) {
        if (this.isContent) {
            if (StringUtil.isEmpty(p.content)) {
                return;
            }
            Matcher matcher = this.pattern.matcher(p.content);
            p.content = MatchUtil.replace(matcher, p.content, this.replace, this.rp_mode);
        } else {
            String text = p.fields.getText(this.field);
            if (StringUtil.isEmpty(text)) {
                return;
            }
            Matcher matcher = this.pattern.matcher(text);
            String newText = MatchUtil.replace(matcher, text, this.replace, this.rp_mode);
            if (newText != text) {
                p.fields.put(this.field, newText);
            }
        }
    }

    public boolean hasMatch(String s) {
        Matcher matcher = this.pattern.matcher(s);
        return matcher.matches();
    }
}

