/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import whatap.agent.jdbc.WrResultSet;
import whatap.agent.jdbc.WrStatement;
import whatap.agent.trace.LocalContext;
import whatap.agent.trace.SqlParameter;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.sql.TraceSQL;

public class WrPreparedStatement
extends WrStatement
implements PreparedStatement {
    final SqlParameter param = new SqlParameter();
    final PreparedStatement inner;

    public WrPreparedStatement(Connection conn, PreparedStatement inner, String sql) {
        super(conn, inner);
        this.inner = inner;
        this.param.setSql(sql);
    }

    public final void setBoolean(int a0, boolean a1) throws SQLException {
        this.inner.setBoolean(a0, a1);
    }

    public final void setByte(int a0, byte a1) throws SQLException {
        this.inner.setByte(a0, a1);
    }

    public final void setShort(int a0, short a1) throws SQLException {
        this.inner.setShort(a0, a1);
    }

    public final void setInt(int a0, int a1) throws SQLException {
        this.inner.setInt(a0, a1);
    }

    public final void setLong(int a0, long a1) throws SQLException {
        this.inner.setLong(a0, a1);
    }

    public final void setFloat(int a0, float a1) throws SQLException {
        this.inner.setFloat(a0, a1);
    }

    public final void setDouble(int a0, double a1) throws SQLException {
        this.inner.setDouble(a0, a1);
    }

    public final void setTimestamp(int a0, Timestamp a1) throws SQLException {
        this.inner.setTimestamp(a0, a1);
    }

    public final void setTimestamp(int a0, Timestamp a1, Calendar a2) throws SQLException {
        this.inner.setTimestamp(a0, a1, a2);
    }

    public final void setURL(int a0, URL a1) throws SQLException {
        this.inner.setURL(a0, a1);
    }

    public final void setTime(int a0, Time a1) throws SQLException {
        this.inner.setTime(a0, a1);
    }

    public final void setTime(int a0, Time a1, Calendar a2) throws SQLException {
        this.inner.setTime(a0, a1, a2);
    }

    public final boolean execute() throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, this.param);
            boolean r = this.inner.execute();
            return TraceSQL.execute(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    public final ResultSet executeQuery() throws SQLException {
        Object stat = null;
        try {
            TraceContext ctx;
            LocalContext lCtx;
            stat = TraceSQL.start((Object)this.inner, this.param);
            ResultSet rs = this.inner.executeQuery();
            TraceSQL.executeQuery(rs, stat);
            if (this.conf.trace_rs_wrap_enabled && !(rs instanceof WrResultSet) && (lCtx = (LocalContext)stat) != null && (ctx = lCtx.context) != null && ctx.executed_sqlhash != 0) {
                return new WrResultSet(rs, ctx.executed_sqlhash, ctx.executed_dbc);
            }
            return rs;
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    public final int executeUpdate() throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, this.param);
            int r = this.inner.executeUpdate();
            return TraceSQL.executeUpdate(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    public final void setNull(int a0, int a1, String a2) throws SQLException {
        this.inner.setNull(a0, a1, a2);
        TraceSQL.set(this.param, a0, null);
    }

    public final void setNull(int a0, int a1) throws SQLException {
        this.inner.setNull(a0, a1);
        TraceSQL.set(this.param, a0, null);
    }

    public final void setBigDecimal(int a0, BigDecimal a1) throws SQLException {
        this.inner.setBigDecimal(a0, a1);
        TraceSQL.set(this.param, a0, a1);
    }

    public final void setString(int a0, String a1) throws SQLException {
        this.inner.setString(a0, a1);
        TraceSQL.set(this.param, a0, a1);
    }

    public final void setBytes(int a0, byte[] a1) throws SQLException {
        this.inner.setBytes(a0, a1);
        TraceSQL.set(this.param, a0, a1);
    }

    public final void setDate(int a0, Date a1, Calendar a2) throws SQLException {
        this.inner.setDate(a0, a1, a2);
        TraceSQL.set(this.param, a0, a1);
    }

    public final void setDate(int a0, Date a1) throws SQLException {
        this.inner.setDate(a0, a1);
        TraceSQL.set(this.param, a0, a1);
    }

    public final void setAsciiStream(int a0, InputStream a1, int a2) throws SQLException {
        this.inner.setAsciiStream(a0, a1, a2);
    }

    public final void setAsciiStream(int a0, InputStream a1) throws SQLException {
        this.inner.setAsciiStream(a0, a1);
    }

    public final void setAsciiStream(int a0, InputStream a1, long a2) throws SQLException {
        this.inner.setAsciiStream(a0, a1, a2);
    }

    public final void setUnicodeStream(int a0, InputStream a1, int a2) throws SQLException {
        this.inner.setUnicodeStream(a0, a1, a2);
    }

    public final void setBinaryStream(int a0, InputStream a1, int a2) throws SQLException {
        this.inner.setBinaryStream(a0, a1, a2);
    }

    public final void setBinaryStream(int a0, InputStream a1, long a2) throws SQLException {
        this.inner.setBinaryStream(a0, a1, a2);
    }

    public final void setBinaryStream(int a0, InputStream a1) throws SQLException {
        this.inner.setBinaryStream(a0, a1);
    }

    public final void clearParameters() throws SQLException {
        this.inner.clearParameters();
        TraceSQL.clear(this.inner, this.param);
    }

    public final void setObject(int a0, Object a1, int a2, int a3) throws SQLException {
        this.inner.setObject(a0, a1, a2, a3);
        TraceSQL.set(this.param, a0, a1);
    }

    public final void setObject(int a0, Object a1, int a2) throws SQLException {
        this.inner.setObject(a0, a1, a2);
        TraceSQL.set(this.param, a0, a1);
    }

    public final void setObject(int a0, Object a1) throws SQLException {
        this.inner.setObject(a0, a1);
        TraceSQL.set(this.param, a0, a1);
    }

    public final void addBatch() throws SQLException {
        this.inner.addBatch();
    }

    public final void setCharacterStream(int a0, Reader a1, long a2) throws SQLException {
        this.inner.setCharacterStream(a0, a1, a2);
    }

    public final void setCharacterStream(int a0, Reader a1, int a2) throws SQLException {
        this.inner.setCharacterStream(a0, a1, a2);
    }

    public final void setCharacterStream(int a0, Reader a1) throws SQLException {
        this.inner.setCharacterStream(a0, a1);
    }

    public final void setRef(int a0, Ref a1) throws SQLException {
        this.inner.setRef(a0, a1);
    }

    public final void setBlob(int a0, InputStream a1, long a2) throws SQLException {
        this.inner.setBlob(a0, a1, a2);
    }

    public final void setBlob(int a0, InputStream a1) throws SQLException {
        this.inner.setBlob(a0, a1);
    }

    public final void setBlob(int a0, Blob a1) throws SQLException {
        this.inner.setBlob(a0, a1);
        TraceSQL.set(this.param, a0, "[blob]");
    }

    public final void setClob(int a0, Reader a1) throws SQLException {
        this.inner.setClob(a0, a1);
        TraceSQL.set(this.param, a0, "[reader]");
    }

    public final void setClob(int a0, Clob a1) throws SQLException {
        this.inner.setClob(a0, a1);
        TraceSQL.set(this.param, a0, "[clob]");
    }

    public final void setClob(int a0, Reader a1, long a2) throws SQLException {
        this.inner.setClob(a0, a1, a2);
        TraceSQL.set(this.param, a0, "[reader]");
    }

    public final void setArray(int a0, Array a1) throws SQLException {
        this.inner.setArray(a0, a1);
        TraceSQL.set(this.param, a0, "[arr]");
    }

    public final ResultSetMetaData getMetaData() throws SQLException {
        return this.inner.getMetaData();
    }

    public final ParameterMetaData getParameterMetaData() throws SQLException {
        return this.inner.getParameterMetaData();
    }

    public final void setRowId(int a0, RowId a1) throws SQLException {
        this.inner.setRowId(a0, a1);
    }

    public final void setNString(int a0, String a1) throws SQLException {
        this.inner.setNString(a0, a1);
    }

    public final void setNCharacterStream(int a0, Reader a1) throws SQLException {
        this.inner.setNCharacterStream(a0, a1);
    }

    public final void setNCharacterStream(int a0, Reader a1, long a2) throws SQLException {
        this.inner.setNCharacterStream(a0, a1, a2);
    }

    public final void setNClob(int a0, Reader a1) throws SQLException {
        this.inner.setNClob(a0, a1);
        TraceSQL.set(this.param, a0, "[nclob]");
    }

    public final void setNClob(int a0, Reader a1, long a2) throws SQLException {
        this.inner.setNClob(a0, a1, a2);
        TraceSQL.set(this.param, a0, "[nclob]");
    }

    public final void setNClob(int a0, NClob a1) throws SQLException {
        this.inner.setNClob(a0, a1);
        TraceSQL.set(this.param, a0, "[nclob]");
    }

    public final void setSQLXML(int a0, SQLXML a1) throws SQLException {
        this.inner.setSQLXML(a0, a1);
        TraceSQL.set(this.param, a0, "[xml]");
    }
}

