/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.data;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataPackSender;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.HvTextPack;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.LongLinkedSet;
import whatap.util.RequestQueue;
import whatap.util.StringKeyLinkedMap;

public class HvTextSendThread
extends Thread {
    private static HvTextSendThread instance;
    RequestQueue<HvTextPack.Record> queue = new RequestQueue(ConfTrace.trace_txsplit_queue_size);
    static final int LIMIT_TOTAL_TEXT_LEN = 2048;
    static final int LIMIT_TIME_WAIT = 3000;
    int pack_text_len;
    long last_send_time;
    HvTextPack pack;
    StringKeyLinkedMap<LongLinkedSet> map = new StringKeyLinkedMap<LongLinkedSet>(){

        @Override
        protected LongLinkedSet create(String key) {
            return new LongLinkedSet().setMax(10000);
        }
    }.setMax(100);
    long last_reset_check;
    long last_reset_timeunit;
    static Configure conf;

    public static final synchronized HvTextSendThread getInstance() {
        if (instance == null) {
            instance = new HvTextSendThread();
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    private HvTextSendThread() {
        ConfObserver.add("HvTextSendThread1", new Runnable(){

            public void run() {
                HvTextSendThread.this.queue.setCapacity(ConfTrace.trace_txsplit_queue_size);
            }
        });
    }

    public void add(String type, String text) {
        long hash = HashUtil.hash64(text);
        this.add(type, hash, text);
    }

    public void add(String type, long hash, String text) {
        this.queue.put(new HvTextPack.Record(type, hash, text));
    }

    public void run() {
        this.pack = new HvTextPack();
        this.pack.time = DateUtil.currentTime();
        while (true) {
            try {
                while (true) {
                    HvTextPack.Record r = this.queue.get(1000L);
                    long now = DateUtil.nanoToMillis();
                    if (r != null) {
                        LongLinkedSet set = this.map.intern(r.type);
                        if (set.put(r.hash) == set.NONE) {
                            this.pack_text_len += r.text.length();
                            this.pack.add(r);
                            if (this.pack_text_len >= 2048) {
                                this.send();
                            }
                        }
                    } else if (now - this.last_send_time >= 3000L) {
                        if (this.pack_text_len > 0) {
                            this.send();
                        } else {
                            this.last_send_time = now;
                        }
                    }
                    if (this.last_reset_check - now <= 1000L) continue;
                    this.last_reset_check = now;
                    long today_reset_timeunit = DateUtil.getHourUnit(DateUtil.currentTime());
                    if (this.last_reset_timeunit == today_reset_timeunit) continue;
                    this.last_reset_timeunit = today_reset_timeunit;
                    if (this.pack_text_len > 0) {
                        this.send();
                    }
                    this.reset();
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private void reset() {
        Enumeration<LongLinkedSet> e1 = this.map.values();
        while (e1.hasMoreElements()) {
            e1.nextElement().clear();
        }
    }

    private void send() {
        this.pack_text_len = 0;
        this.last_send_time = DateUtil.nanoToMillis();
        DataPackSender.setInfo(this.pack);
        DataPackSender.sentZip(this.pack);
        this.pack = new HvTextPack();
        this.pack.time = DateUtil.currentTime();
    }

    static {
        conf = Configure.getInstance();
    }
}

