/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.res.util;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import whatap.agent.Logger;
import whatap.agent.counter.task.res.util.JmxProxy;
import whatap.util.SystemUtil;

public class JmxSunProxy
implements JmxProxy {
    private static final int JAVA_7 = 51;
    boolean isSunJmx;
    boolean isSunProcJmx;
    boolean isSunMemJmx;
    boolean isSunSwapJmx;
    boolean supportsSystemCpu;
    int cores = 1;
    Object bean;

    public JmxSunProxy() {
        try {
            OperatingSystemMXBean tempBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            this.isSunJmx = true;
            this.cores = tempBean.getAvailableProcessors();
            if (SystemUtil.majorVersion >= 51) {
                this.supportsSystemCpu = true;
            } else {
                Logger.println("JmxSunProxy", "method getSystemCpuLoad requires java 1.7, hotfix: sigar_enabled=true");
                this.supportsSystemCpu = false;
            }
            try {
                this.isSunProcJmx = tempBean.getProcessCpuLoad() >= 0.0;
            }
            catch (Exception e) {
                Logger.println("A145", 10, e.getMessage());
            }
            try {
                this.isSunMemJmx = tempBean.getTotalPhysicalMemorySize() > 0L;
                this.isSunSwapJmx = tempBean.getTotalSwapSpaceSize() > 0L;
            }
            catch (Exception e) {
                Logger.println("A146", 10, e.getMessage());
            }
            this.bean = tempBean;
        }
        catch (Throwable t) {
            this.supportsSystemCpu = false;
            Logger.println("A147", 10, t.getMessage());
        }
    }

    public float cpu() {
        if (!this.supportsSystemCpu) {
            return 0.0f;
        }
        if (this.bean == null) {
            return 0.0f;
        }
        try {
            double cpuUsage = ((OperatingSystemMXBean)this.bean).getSystemCpuLoad();
            if (cpuUsage < 0.0) {
                return 0.0f;
            }
            if (!this.isSunProcJmx) {
                this.isSunProcJmx = true;
            }
            return (float)(cpuUsage * 100.0);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public float processCpu() {
        if (!this.isSunProcJmx) {
            return 0.0f;
        }
        try {
            return (float)((OperatingSystemMXBean)this.bean).getProcessCpuLoad() * 100.0f;
        }
        catch (Exception e) {
            this.isSunProcJmx = false;
            return 0.0f;
        }
    }

    public float mem() {
        if (!this.isSunMemJmx) {
            this.isSunMemJmx = ((OperatingSystemMXBean)this.bean).getTotalPhysicalMemorySize() > 0L;
            return 0.0f;
        }
        try {
            long t = ((OperatingSystemMXBean)this.bean).getTotalPhysicalMemorySize();
            long f = ((OperatingSystemMXBean)this.bean).getFreePhysicalMemorySize();
            return (float)(t - f) * 100.0f / (float)t;
        }
        catch (Exception e) {
            this.isSunMemJmx = false;
            return 0.0f;
        }
    }

    public long memUseTotal() {
        long t = ((OperatingSystemMXBean)this.bean).getTotalPhysicalMemorySize();
        long f = ((OperatingSystemMXBean)this.bean).getFreePhysicalMemorySize();
        return t - f;
    }

    public float swap() {
        long t = ((OperatingSystemMXBean)this.bean).getTotalSwapSpaceSize();
        long f = ((OperatingSystemMXBean)this.bean).getFreeSwapSpaceSize();
        return (float)(t - f) * 100.0f / (float)t;
    }

    public static void main(String[] args) {
        System.out.println(new JmxSunProxy().mem());
        System.out.println(new JmxSunProxy().swap());
    }
}

