/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.res;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.meter.ThreadDump;
import whatap.agent.proxy.ISigar;
import whatap.agent.proxy.SigarFactory;
import whatap.agent.trace.Alert;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.NETSTAT;
import whatap.lang.value.MapValue;
import whatap.sigar.CpuPerc;
import whatap.sigar.FileSystemUsage;
import whatap.sigar.Mem;
import whatap.sigar.NetStat;
import whatap.sigar.ProcCpu;
import whatap.sigar.ProcMem;
import whatap.sigar.Swap;
import whatap.util.DeferedRun;

public class SystemSigarTask
implements ICounterTask {
    private ISigar sigar;
    private DeferedRun<Float> disk = new DeferedRun<Float>(new DeferedRun.Exec<Float>(){

        @Override
        public Float call() {
            long stime = System.currentTimeMillis();
            FileSystemUsage fs = SystemSigarTask.this.sigar.getFileSystemUsage(ConfSysMon.sigar_disk_path);
            long etime = System.currentTimeMillis();
            if (etime - stime >= 500L) {
                Logger.red("Warning!! sigar.disk(\"" + ConfSysMon.sigar_disk_path + "\") " + (etime - stime) + " ms");
            }
            return Float.valueOf(fs == null ? 0.0f : (float)fs.usedPercent);
        }
    }, ConfSysMon.sigar_disk_interval, Float.valueOf(0.0f));
    private long last_over_start;

    public SystemSigarTask() {
        this.sigar = SigarFactory.create();
        this.sigar.getCpuPerc();
    }

    public void process(CounterPack1 p) {
        try {
            this.doProcess(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Configure conf = Configure.getInstance();
        if (conf.thread_dump_enabled && conf.thread_dump_cpu > 0 && p.cpu > (float)conf.thread_dump_cpu) {
            ThreadDump.trigger();
        }
    }

    private void doProcess(CounterPack1 p) {
        Swap w;
        Mem m;
        ProcMem pmem;
        long pid;
        ProcCpu pcpu;
        if (this.sigar == null || !this.sigar.isOk()) {
            return;
        }
        long now = System.currentTimeMillis();
        CpuPerc vc = this.sigar.getCpuPerc();
        if (vc != null) {
            p.cpu = (float)(vc.total * 100.0 * (double)ConfSysMon.correction_factor_cpu);
            p.cpu_sys = (float)(vc.sys * 100.0);
            p.cpu_usr = (float)(vc.user * 100.0);
            p.cpu_wait = (float)(vc.wait * 100.0);
            p.cpu_steal = (float)(vc.stolen * 100.0);
            p.cpu_irq = (float)(vc.irq * 100.0);
        }
        if (ConfSysMon.cpu_event_enabled) {
            if (p.cpu >= (float)ConfSysMon.cpu_event_percent) {
                if (this.last_over_start == 0L) {
                    this.last_over_start = now;
                }
            } else {
                this.last_over_start = 0L;
            }
            if (this.last_over_start > 0L && now - this.last_over_start >= (long)ConfSysMon.cpu_event_duration) {
                Alert.heapRate(p.cpu);
                this.last_over_start = 0L;
            }
        }
        if ((pcpu = this.sigar.getProcCpu(pid = this.sigar.getPid())) != null) {
            p.cpu_proc = (float)(pcpu.percent * (double)ConfSysMon.correction_factor_pcpu);
        }
        if ((pmem = this.sigar.getProcMem(pid)) != null) {
            if (p.extra == null) {
                p.extra = new MapValue();
            }
            p.extra.put("proc_mem_rss", pmem.resident);
        }
        if (ConfSysMon.sigar_disk_enabled) {
            this.disk.setInterval(ConfSysMon.sigar_disk_interval);
            p.disk = this.disk.call().floatValue();
        }
        if (ConfSysMon.disk_event_enabled && p.disk >= (float)ConfSysMon.disk_event_percent) {
            Alert.diskRate(p.disk);
        }
        if ((m = this.sigar.getMem()) != null) {
            p.mem = (float)m.usedPercent;
        }
        if ((w = this.sigar.getSwap()) != null) {
            p.swap = w.used;
        }
        if (Configure.getInstance().counter_netstat_enabled) {
            NetStat nets = this.sigar.getNetStat();
            p.netstat = new NETSTAT();
            if (nets != null) {
                p.netstat.est = nets.established;
                p.netstat.fin_w = nets.finWait1 + nets.finWait2;
                p.netstat.clo_w = nets.closeWait;
                p.netstat.tim_w = nets.timeWait;
            }
        }
    }
}

