/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.res;

import whatap.agent.conf.ConfSysMon;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.task.res.util.LinuxProcStatUtil;
import whatap.lang.pack.CounterPack1;
import whatap.util.SysJMX;

public class SystemLinuxTask
implements ICounterTask {
    public void process(CounterPack1 p) {
        LinuxProcStatUtil.CPUStat c = LinuxProcStatUtil.getCpu();
        if (c != null) {
            p.cpu = c.pct * ConfSysMon.correction_factor_cpu;
            p.cpu_sys = c.system;
            p.cpu_usr = c.user;
            p.cpu_wait = c.iowait;
            p.cpu_steal = c.steal;
            p.cpu_irq = c.irq;
        }
        p.cpu_proc = LinuxProcStatUtil.getProcCpu(SysJMX.getProcessPID()) * ConfSysMon.correction_factor_pcpu;
        LinuxProcStatUtil.Memory m = LinuxProcStatUtil.getMemory();
        if (m != null) {
            p.mem = m.total == 0L ? 0.0f : (float)(m.total - m.available) * 100.0f / (float)m.total;
            p.swap = m.swaptotal == 0L ? 0.0f : (float)(m.swaptotal - m.free) * 100.0f / (float)m.swaptotal;
        }
        p.metering = p.cpu_cores;
    }
}

