/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.hikari;

import java.lang.ref.WeakReference;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfPool;
import whatap.agent.counter.task.hikari.IHikariPool;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.ListValue;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

public class HikariPoolCollector {
    static Configure conf = Configure.getInstance();
    static StringKeyLinkedMap<WeakReference<IHikariPool>> table = new StringKeyLinkedMap().setMax(1000);

    public static void regist(String id, IHikariPool pool) {
        table.put(id, new WeakReference<IHikariPool>(pool));
    }

    public static void process(CounterPack1 p) {
        String[] poolNames;
        if (table.size() == 0) {
            return;
        }
        if (p.db_num_active == null) {
            p.db_num_active = new IntIntMap(7, 1.0f);
        }
        if (p.db_num_idle == null) {
            p.db_num_idle = new IntIntMap(7, 1.0f);
        }
        ListValue nameListValue = new ListValue();
        ListValue totalConnectionListValue = new ListValue();
        ListValue activeConnectionListValue = new ListValue();
        ListValue idleConnectionListValue = new ListValue();
        ListValue threadsAwaitingConnectionListValue = new ListValue();
        ListValue maximumPoolSizeListValue = new ListValue();
        ListValue minimumIdleListValue = new ListValue();
        ListValue connectionTimeoutCounterListValue = new ListValue();
        ListValue connectionCreatedTimeListValue = new ListValue();
        ListValue connectionUsageTimeListValue = new ListValue();
        ListValue connectionAcquiredTimeListValue = new ListValue();
        ListValue connectionTimeoutListValue = new ListValue();
        for (String poolName : poolNames = table.keyArray()) {
            WeakReference<IHikariPool> wk = table.get(poolName);
            IHikariPool pool = (IHikariPool)wk.get();
            if (pool == null) {
                table.remove(poolName);
                continue;
            }
            int poolHash = HashUtil.hash(poolName);
            DataTextAgent.dbc(poolHash, poolName);
            int act = pool.getActiveCount();
            int idle = pool.getIdleCount();
            p.db_num_active.put(poolHash, act);
            p.db_num_idle.put(poolHash, idle);
            if (ConfPool.metric_hikari_pool_enabled) {
                int totalConnections = pool.getTotalConnections();
                int idleConnections = pool.getIdleConnections();
                int activeConnections = pool.getActiveConnections();
                int threadsAwaitingConnection = pool.getThreadsAwaitingConnection();
                int maximumPoolSize = pool.getMaximumPoolSize();
                int minimumIdle = pool.getMinimumIdle();
                int connectionTimeoutCounter = pool.getConnectionTimeoutCounter();
                long connectionCreatedTime = pool.getConnectionCreatedTime() / 1000000L;
                long connectionUsageTime = pool.getConnectionUsageTime() / 1000000L;
                long connectionAcquiredTime = pool.getConnectionAcquiredTime() / 1000000L;
                long connectionTimeout = pool.getConnectionTimeout() / 1000000L;
                pool.initializeStats();
                nameListValue.add(poolName);
                totalConnectionListValue.add(totalConnections);
                activeConnectionListValue.add(activeConnections);
                idleConnectionListValue.add(idleConnections);
                maximumPoolSizeListValue.add(maximumPoolSize);
                minimumIdleListValue.add(minimumIdle);
                threadsAwaitingConnectionListValue.add(threadsAwaitingConnection);
                connectionTimeoutCounterListValue.add(connectionTimeoutCounter);
                connectionCreatedTimeListValue.add(connectionCreatedTime);
                connectionUsageTimeListValue.add(connectionUsageTime);
                connectionAcquiredTimeListValue.add(connectionAcquiredTime);
                connectionTimeoutListValue.add(connectionTimeout);
            }
            if (!ConfPool.pool_detail_enabled) continue;
            TagCountPack pk = new TagCountPack();
            pk.category = "db_pool_detail";
            pk.time = DateUtil.now() / 5000L * 5000L;
            if (StringUtil.isNotEmpty(HikariPoolCollector.conf.OKIND_NAME)) {
                pk.putTag("okindName", HikariPoolCollector.conf.OKIND_NAME);
            }
            if (StringUtil.isNotEmpty(HikariPoolCollector.conf.ONODE_NAME)) {
                pk.putTag("onodeName", HikariPoolCollector.conf.ONODE_NAME);
            }
            pk.putTag("oname", SecurityMaster.getInstance().ONAME);
            pk.putTag("pool", poolName);
            pk.putTag("class", "HikariPool");
            pk.put("act", act);
            pk.put("idle", idle);
            DataPackSender.send(pk);
        }
        if (ConfPool.metric_hikari_pool_enabled) {
            TagCountPack pk = new TagCountPack();
            pk.category = "hikari_pool";
            pk.time = DateUtil.now() / 5000L * 5000L;
            if (StringUtil.isNotEmpty(HikariPoolCollector.conf.OKIND_NAME)) {
                pk.putTag("okindName", HikariPoolCollector.conf.OKIND_NAME);
            }
            if (StringUtil.isNotEmpty(HikariPoolCollector.conf.ONODE_NAME)) {
                pk.putTag("onodeName", HikariPoolCollector.conf.ONODE_NAME);
            }
            pk.putTag("oname", SecurityMaster.getInstance().ONAME);
            pk.put("poolName", nameListValue);
            pk.put("totalConnection", totalConnectionListValue);
            pk.put("activeConnection", activeConnectionListValue);
            pk.put("idleConnection", idleConnectionListValue);
            pk.put("maximumPoolSize", maximumPoolSizeListValue);
            pk.put("minimumIdle", minimumIdleListValue);
            pk.put("threadsAwaitingConnection", threadsAwaitingConnectionListValue);
            pk.put("connectionTimeoutCounter", connectionTimeoutCounterListValue);
            pk.put("connectionCreatedTime", connectionCreatedTimeListValue);
            pk.put("connectionUsageTime", connectionUsageTimeListValue);
            pk.put("connectionAcquiredTime", connectionAcquiredTimeListValue);
            pk.put("connectionTimeout", connectionTimeoutListValue);
            if (ConfPool.debug_metric_hikari_pool_enabled) {
                Logger.println("HikariPool", "hikari_pool=" + pk.category + " " + pk.tags + " " + pk.fields);
            }
            DataPackSender.send(pk);
        }
    }
}

