/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.csp;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import whatap.agent.Logger;
import whatap.agent.boot.CloudPlatformHelper;

public class KicCheck {
    static boolean KIC_CHECK_RESULT = false;
    static String meta_uri = "http://169.254.169.254/latest/meta-data/placement/availability-zone";
    static int maxTestCount = 5;

    public static boolean isKic() {
        if (KIC_CHECK_RESULT || maxTestCount < 0) {
            return KIC_CHECK_RESULT;
        }
        --maxTestCount;
        try {
            String zone = KicCheck.read(new URL(meta_uri), 3000);
            if (zone == null) {
                return KIC_CHECK_RESULT;
            }
            if (zone.indexOf("kr-central-1") >= 0) {
                Logger.println("This agent is working in KIC");
                KIC_CHECK_RESULT = true;
            }
        }
        catch (Throwable e) {
            Logger.println(KicCheck.class.getSimpleName(), e);
        }
        return KIC_CHECK_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(URL u, int timeout) {
        HttpURLConnection uc = null;
        try {
            uc = (HttpURLConnection)u.openConnection();
            if (timeout > 0) {
                uc.setConnectTimeout(timeout);
            }
            uc.connect();
            InputStream in = uc.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int length = 0;
            while ((length = in.read(buf)) >= 0) {
                out.write(buf, 0, length);
            }
            CloudPlatformHelper.HAS_CHECKED = true;
            String string = new String(out.toByteArray());
            return string;
        }
        catch (SocketTimeoutException e) {
            Logger.println("KIC check fail : " + e);
        }
        catch (Exception e) {
            Logger.println("KIC check fail : " + e);
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
        Logger.println("KIC check fail : unknown");
        return null;
    }
}

