/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.counter.ICounterTask;
import whatap.agent.trace.Alert;
import whatap.lang.pack.CounterPack1;
import whatap.util.SystemUtil;

public class ResProcHeap
implements ICounterTask {
    MemoryPoolMXBean permGenBean;
    MemoryMXBean membean;
    Configure conf = Configure.getInstance();
    static long last_over_start = System.currentTimeMillis();

    public void init() {
        if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
            return;
        }
        try {
            this.membean = ManagementFactory.getMemoryMXBean();
            List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean bean : beans) {
                String n = bean.getName().toUpperCase();
                if (n.indexOf("PERM GEN") < 0 && n.indexOf("METASPACE") < 0) continue;
                this.permGenBean = bean;
                break;
            }
        }
        catch (Throwable t) {
            Logger.println(this.getClass().getName(), t);
        }
    }

    public void process(CounterPack1 p) {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        long now = System.currentTimeMillis();
        p.heap_tot = total;
        p.heap_use = used;
        p.heap_max = Runtime.getRuntime().maxMemory();
        try {
            if (this.conf.heap_event_enabled && total > 0L) {
                float rate = (float)used * 100.0f / (float)total;
                if (rate >= (float)this.conf.heap_event_percent) {
                    if (last_over_start == 0L) {
                        last_over_start = now;
                    }
                } else {
                    last_over_start = 0L;
                }
                if (last_over_start > 0L && now - last_over_start >= (long)this.conf.heap_event_duration) {
                    Alert.heapRate(rate);
                    last_over_start = 0L;
                }
            }
            if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
                return;
            }
            if (this.membean == null) {
                this.init();
            }
            p.heap_pending_finalization = this.membean.getObjectPendingFinalizationCount();
            if (this.permGenBean != null) {
                MemoryUsage usage = this.permGenBean.getUsage();
                p.heap_perm = usage.getUsed();
            }
        }
        catch (Exception e) {
            Logger.red("[ResProcHeap] " + e);
        }
    }
}

