/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import whatap.agent.Logger;
import whatap.agent.counter.ICounterTask;
import whatap.agent.util.OldGcBeanFinder;
import whatap.lang.pack.CounterPack1;
import whatap.util.SystemUtil;

public class ResProcGC
implements ICounterTask {
    long lastTime = -1L;
    long lastCount = -1L;
    long lastOldGcCount = -1L;
    boolean err;

    public void process(CounterPack1 p) {
        if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
            return;
        }
        try {
            if (!this.err) {
                this.realprocess(p);
            }
        }
        catch (Throwable t) {
            this.err = true;
            Logger.println(this.getClass().getName(), t);
        }
    }

    protected void realprocess(CounterPack1 p) {
        if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
            return;
        }
        long gcTime = 0L;
        long gcCount = 0L;
        for (GarbageCollectorMXBean curGcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long curCount = curGcBean.getCollectionCount();
            long curTime = curGcBean.getCollectionTime();
            if (curCount < 0L) continue;
            gcTime += curTime;
            gcCount += curCount;
        }
        long oldGcCount = OldGcBeanFinder.getMXBean().getCollectionCount();
        if (this.lastCount >= 0L) {
            p.gc_count = (int)(gcCount - this.lastCount);
            p.gc_time_sum = gcTime - this.lastTime;
            p.gc_oldgen_count = (int)(oldGcCount - this.lastOldGcCount);
        }
        this.lastCount = gcCount;
        this.lastTime = gcTime;
        this.lastOldGcCount = oldGcCount;
    }
}

