/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfUser;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.meter.MeterUsers;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.RealtimeUserPack1;
import whatap.util.cardinality.HyperLogLog;

public class RealtimeUser
implements ICounterTask {
    Configure conf = Configure.getInstance();

    public RealtimeUser() {
        MeterUsers.getRealtimeUsers();
    }

    public void process(CounterPack1 p) {
        if (!ConfUser.wclient_enabled) {
            return;
        }
        if (this.conf.realtime_interval == 5000) {
            RealtimeUser.collectRealtimeUser(p.time);
        }
    }

    public static void collectRealtimeUser(long time) {
        HyperLogLog hll = MeterUsers.getRealtimeUsers();
        if (hll == null) {
            return;
        }
        MeterUsers.users.setMax(ConfUser.wclient_max_count);
        RealtimeUserPack1 pk = new RealtimeUserPack1();
        pk.time = time;
        pk.cadinality = (int)hll.cardinality();
        pk.logbits = hll.getBytes();
        DataPackSender.send(pk);
        if (ConfUser.log != null) {
            Logger.green(ConfUser.log);
            ConfUser.log = null;
        }
    }
}

