/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control.profile;

import java.lang.instrument.ClassDefinition;
import java.util.List;
import whatap.agent.Logger;
import whatap.agent.control.profile.DynaHook;
import whatap.agent.control.profile.RedefineUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringLinkedSet;

public class DynaMethodProfile {
    public StringKeyLinkedMap<DynaHook> table = new StringKeyLinkedMap().setMax(10000);

    public String apply() {
        StringLinkedSet target = new StringLinkedSet();
        StringEnumer en = this.table.keys();
        while (en.hasMoreElements()) {
            String className = en.nextString();
            DynaHook m = this.table.get(className);
            switch (m.stat) {
                case 1: 
                case 2: {
                    target.put(className);
                }
            }
        }
        if (target.size() == 0) {
            return "ok-none";
        }
        try {
            List<ClassDefinition> result = RedefineUtil.redefine(target);
            for (ClassDefinition c : result) {
                String className = c.getDefinitionClass().getName();
                target.remove(className);
                DynaHook m = this.table.get(className);
                if (m == null) continue;
                target.remove(className);
            }
        }
        catch (Exception e) {
            Logger.println(e.toString());
            return "error-" + e.getMessage();
        }
        return "ok";
    }

    public DynaHook getDyna(String className) {
        if (this.table.size() == 0) {
            return null;
        }
        DynaHook h = this.table.get(className);
        if (h == null) {
            return null;
        }
        return h.stat == 0 ? null : h;
    }

    public DynaHook newDyna(String className) {
        DynaHook h = new DynaHook();
        this.table.put(className, h);
        return h;
    }
}

