/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control.ds;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.control.ds.JavaXDBConPoolFold;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.data.DataPackSender;
import whatap.agent.trace.ConPool;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPoolClassUtil {
    private static HashSet<String> ignore = new HashSet();
    static Configure conf;

    public static void readDbPoolStatus(String classId, MapValue result, String fContext, String fName, String fKey) throws Exception {
        ListValue contextLv = result.internList("context");
        ListValue nameLv = result.internList("name");
        ListValue keyLv = result.internList("key");
        ListValue valueLv = result.internList("value");
        Configure conf = Configure.getInstance();
        Enumeration<WeakReference<Object>> poolEnum = ConPool.getObjectEnum(classId);
        if (ConPool.isEmpty(poolEnum)) {
            return;
        }
        boolean hasFilter = StringUtil.isNotEmpty(fContext) || StringUtil.isNotEmpty(fName) || StringUtil.isNotEmpty(fKey);
        try {
            while (poolEnum.hasMoreElements()) {
                Object o = poolEnum.nextElement().get();
                if (o == null) continue;
                String className = o.getClass().getName() + "(" + o.hashCode() + ")";
                if (DBPoolClassUtil.isHikariPool(o.getClass().getName())) {
                    contextLv.add(classId);
                    nameLv.add(className);
                    keyLv.add("name");
                    valueLv.add(o.toString());
                }
                Method[] m = o.getClass().getMethods();
                for (int i = 0; i < m.length; ++i) {
                    String methodName;
                    if (m[i].getParameterTypes().length > 0 || ignore.contains(methodName = m[i].getName()) || conf.dbpool_ignore_method.contains(methodName) || !DBPoolClassUtil.isRtnOk(m[i].getReturnType())) continue;
                    try {
                        if (hasFilter && (!DBPoolClassUtil.has(classId, fContext) || !DBPoolClassUtil.has(className, fName) || !DBPoolClassUtil.has(methodName, fKey))) continue;
                        contextLv.add(classId);
                        nameLv.add(className);
                        keyLv.add(methodName);
                        try {
                            Object v = m[i].invoke(o, new Object[0]);
                            valueLv.add(CastUtil.cString(v));
                        }
                        catch (InvocationTargetException re) {
                            valueLv.add(re.toString());
                        }
                        continue;
                    }
                    catch (Throwable e) {
                        Logger.println("A219", 10, "e1 " + methodName + " " + e, e);
                    }
                }
            }
        }
        catch (Throwable t) {
            Logger.println("A219", 10, "e2 " + t, t);
        }
    }

    private static boolean isHikariPool(String name) {
        return name.equals("com.zaxxer.hikari.pool.HikariPool");
    }

    private static boolean isRtnOk(Class<?> rt) {
        if (rt == Integer.TYPE || rt == Integer.class) {
            return true;
        }
        if (rt == Long.TYPE || rt == Long.class) {
            return true;
        }
        if (rt == Float.TYPE || rt == Float.class) {
            return true;
        }
        if (rt == Double.TYPE || rt == Double.class) {
            return true;
        }
        if (rt == Boolean.TYPE || rt == Boolean.class) {
            return true;
        }
        return rt == String.class;
    }

    private static boolean has(String k, String filter) {
        if (StringUtil.isEmpty(filter)) {
            return true;
        }
        return k.contains(filter);
    }

    public static void poolDetail(String classId, StringKeyLinkedMap<CNT> pool) {
        if (pool == null || pool.size() == 0) {
            return;
        }
        if (DBPoolClassUtil.conf.tagcount_subset_v1_enabled) {
            DBPoolClassUtil.orgin(classId, pool);
        }
        if (DBPoolClassUtil.conf.tagcount_subset_v2_enabled) {
            JavaXDBConPoolFold.prepare(classId, pool);
        }
    }

    private static void orgin(String classId, StringKeyLinkedMap<CNT> pool) {
        StringEnumer en = pool.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            CNT cnt = pool.get(key);
            TagCountPack pk = new TagCountPack();
            pk.category = "db_pool_detail";
            pk.time = DateUtil.now() / 5000L * 5000L;
            if (StringUtil.isNotEmpty(DBPoolClassUtil.conf.OKIND_NAME)) {
                pk.putTag("okindName", DBPoolClassUtil.conf.OKIND_NAME);
            }
            if (StringUtil.isNotEmpty(DBPoolClassUtil.conf.ONODE_NAME)) {
                pk.putTag("onodeName", DBPoolClassUtil.conf.ONODE_NAME);
            }
            pk.putTag("oname", SecurityMaster.getInstance().ONAME);
            pk.putTag("pool", key);
            pk.putTag("class", classId);
            pk.put("act", cnt.act);
            pk.put("idle", cnt.idle);
            DataPackSender.send(pk);
        }
    }

    static {
        ignore.add("toString");
        ignore.add("hashCode");
        ignore.add("getClass");
        ignore.add("getGroups");
        ignore.add("getResources");
        ignore.add("getConnection");
        ignore.add("getLogWriter");
        ignore.add("getPassword");
        ignore.add("purge");
        ignore.add("purgeOnReturn");
        ignore.add("testAllIdle");
        ignore.add("dump");
        ignore.add("fill");
        ignore.add("removeAbandoned");
        conf = Configure.getInstance();
    }
}

